/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MetricSingleDimension
implements JsonSerializable<MetricSingleDimension> {
    private String name;
    private String value;
    private static final ClientLogger LOGGER = new ClientLogger(MetricSingleDimension.class);

    public String name() {
        return this.name;
    }

    public MetricSingleDimension withName(String name) {
        this.name = name;
        return this;
    }

    public String value() {
        return this.value;
    }

    public MetricSingleDimension withValue(String value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model MetricSingleDimension"));
        }
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model MetricSingleDimension"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    public static MetricSingleDimension fromJson(JsonReader jsonReader) throws IOException {
        return (MetricSingleDimension)jsonReader.readObject(reader -> {
            MetricSingleDimension deserializedMetricSingleDimension = new MetricSingleDimension();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedMetricSingleDimension.name = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedMetricSingleDimension.value = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricSingleDimension;
        });
    }
}

