/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.MetricAlertAction;
import com.azure.resourcemanager.monitor.models.MetricAlertCriteria;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;

public final class MetricAlertProperties
implements JsonSerializable<MetricAlertProperties> {
    private String description;
    private int severity;
    private boolean enabled;
    private List<String> scopes;
    private Duration evaluationFrequency;
    private Duration windowSize;
    private String targetResourceType;
    private String targetResourceRegion;
    private MetricAlertCriteria criteria;
    private Boolean autoMitigate;
    private List<MetricAlertAction> actions;
    private OffsetDateTime lastUpdatedTime;
    private Boolean isMigrated;
    private static final ClientLogger LOGGER = new ClientLogger(MetricAlertProperties.class);

    public String description() {
        return this.description;
    }

    public MetricAlertProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public int severity() {
        return this.severity;
    }

    public MetricAlertProperties withSeverity(int severity) {
        this.severity = severity;
        return this;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public MetricAlertProperties withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<String> scopes() {
        return this.scopes;
    }

    public MetricAlertProperties withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public Duration evaluationFrequency() {
        return this.evaluationFrequency;
    }

    public MetricAlertProperties withEvaluationFrequency(Duration evaluationFrequency) {
        this.evaluationFrequency = evaluationFrequency;
        return this;
    }

    public Duration windowSize() {
        return this.windowSize;
    }

    public MetricAlertProperties withWindowSize(Duration windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    public String targetResourceType() {
        return this.targetResourceType;
    }

    public MetricAlertProperties withTargetResourceType(String targetResourceType) {
        this.targetResourceType = targetResourceType;
        return this;
    }

    public String targetResourceRegion() {
        return this.targetResourceRegion;
    }

    public MetricAlertProperties withTargetResourceRegion(String targetResourceRegion) {
        this.targetResourceRegion = targetResourceRegion;
        return this;
    }

    public MetricAlertCriteria criteria() {
        return this.criteria;
    }

    public MetricAlertProperties withCriteria(MetricAlertCriteria criteria) {
        this.criteria = criteria;
        return this;
    }

    public Boolean autoMitigate() {
        return this.autoMitigate;
    }

    public MetricAlertProperties withAutoMitigate(Boolean autoMitigate) {
        this.autoMitigate = autoMitigate;
        return this;
    }

    public List<MetricAlertAction> actions() {
        return this.actions;
    }

    public MetricAlertProperties withActions(List<MetricAlertAction> actions) {
        this.actions = actions;
        return this;
    }

    public OffsetDateTime lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Boolean isMigrated() {
        return this.isMigrated;
    }

    public void validate() {
        if (this.scopes() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property scopes in model MetricAlertProperties"));
        }
        if (this.evaluationFrequency() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property evaluationFrequency in model MetricAlertProperties"));
        }
        if (this.windowSize() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property windowSize in model MetricAlertProperties"));
        }
        if (this.criteria() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property criteria in model MetricAlertProperties"));
        }
        this.criteria().validate();
        if (this.actions() != null) {
            this.actions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("severity", this.severity);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeArrayField("scopes", this.scopes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("evaluationFrequency", CoreUtils.durationToStringWithDays((Duration)this.evaluationFrequency));
        jsonWriter.writeStringField("windowSize", CoreUtils.durationToStringWithDays((Duration)this.windowSize));
        jsonWriter.writeJsonField("criteria", (JsonSerializable)this.criteria);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("targetResourceType", this.targetResourceType);
        jsonWriter.writeStringField("targetResourceRegion", this.targetResourceRegion);
        jsonWriter.writeBooleanField("autoMitigate", this.autoMitigate);
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static MetricAlertProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MetricAlertProperties)jsonReader.readObject(reader -> {
            MetricAlertProperties deserializedMetricAlertProperties = new MetricAlertProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("severity".equals(fieldName)) {
                    deserializedMetricAlertProperties.severity = reader.getInt();
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedMetricAlertProperties.enabled = reader.getBoolean();
                    continue;
                }
                if ("scopes".equals(fieldName)) {
                    List scopes;
                    deserializedMetricAlertProperties.scopes = scopes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("evaluationFrequency".equals(fieldName)) {
                    deserializedMetricAlertProperties.evaluationFrequency = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("windowSize".equals(fieldName)) {
                    deserializedMetricAlertProperties.windowSize = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("criteria".equals(fieldName)) {
                    deserializedMetricAlertProperties.criteria = MetricAlertCriteria.fromJson(reader);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMetricAlertProperties.description = reader.getString();
                    continue;
                }
                if ("targetResourceType".equals(fieldName)) {
                    deserializedMetricAlertProperties.targetResourceType = reader.getString();
                    continue;
                }
                if ("targetResourceRegion".equals(fieldName)) {
                    deserializedMetricAlertProperties.targetResourceRegion = reader.getString();
                    continue;
                }
                if ("autoMitigate".equals(fieldName)) {
                    deserializedMetricAlertProperties.autoMitigate = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List actions;
                    deserializedMetricAlertProperties.actions = actions = reader.readArray(reader1 -> MetricAlertAction.fromJson(reader1));
                    continue;
                }
                if ("lastUpdatedTime".equals(fieldName)) {
                    deserializedMetricAlertProperties.lastUpdatedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("isMigrated".equals(fieldName)) {
                    deserializedMetricAlertProperties.isMigrated = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricAlertProperties;
        });
    }
}

