/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.DataCollectionRule;
import com.azure.resourcemanager.monitor.models.DataCollectionRuleDataSources;
import com.azure.resourcemanager.monitor.models.DataCollectionRuleDestinations;
import com.azure.resourcemanager.monitor.models.DataCollectionRuleMetadata;
import com.azure.resourcemanager.monitor.models.DataFlow;
import com.azure.resourcemanager.monitor.models.KnownDataCollectionRuleProvisioningState;
import com.azure.resourcemanager.monitor.models.StreamDeclaration;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DataCollectionRuleResourceProperties
extends DataCollectionRule {
    private String immutableId;
    private DataCollectionRuleMetadata metadata;
    private KnownDataCollectionRuleProvisioningState provisioningState;

    @Override
    public String immutableId() {
        return this.immutableId;
    }

    @Override
    public DataCollectionRuleMetadata metadata() {
        return this.metadata;
    }

    @Override
    public KnownDataCollectionRuleProvisioningState provisioningState() {
        return this.provisioningState;
    }

    @Override
    public DataCollectionRuleResourceProperties withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public DataCollectionRuleResourceProperties withDataCollectionEndpointId(String dataCollectionEndpointId) {
        super.withDataCollectionEndpointId(dataCollectionEndpointId);
        return this;
    }

    @Override
    public DataCollectionRuleResourceProperties withStreamDeclarations(Map<String, StreamDeclaration> streamDeclarations) {
        super.withStreamDeclarations(streamDeclarations);
        return this;
    }

    @Override
    public DataCollectionRuleResourceProperties withDataSources(DataCollectionRuleDataSources dataSources) {
        super.withDataSources(dataSources);
        return this;
    }

    @Override
    public DataCollectionRuleResourceProperties withDestinations(DataCollectionRuleDestinations destinations) {
        super.withDestinations(destinations);
        return this;
    }

    @Override
    public DataCollectionRuleResourceProperties withDataFlows(List<DataFlow> dataFlows) {
        super.withDataFlows(dataFlows);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("dataCollectionEndpointId", this.dataCollectionEndpointId());
        jsonWriter.writeMapField("streamDeclarations", this.streamDeclarations(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("dataSources", (JsonSerializable)this.dataSources());
        jsonWriter.writeJsonField("destinations", (JsonSerializable)this.destinations());
        jsonWriter.writeArrayField("dataFlows", this.dataFlows(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DataCollectionRuleResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DataCollectionRuleResourceProperties)jsonReader.readObject(reader -> {
            DataCollectionRuleResourceProperties deserializedDataCollectionRuleResourceProperties = new DataCollectionRuleResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedDataCollectionRuleResourceProperties.withDescription(reader.getString());
                    continue;
                }
                if ("immutableId".equals(fieldName)) {
                    deserializedDataCollectionRuleResourceProperties.immutableId = reader.getString();
                    continue;
                }
                if ("dataCollectionEndpointId".equals(fieldName)) {
                    deserializedDataCollectionRuleResourceProperties.withDataCollectionEndpointId(reader.getString());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    deserializedDataCollectionRuleResourceProperties.metadata = DataCollectionRuleMetadata.fromJson(reader);
                    continue;
                }
                if ("streamDeclarations".equals(fieldName)) {
                    Map streamDeclarations = reader.readMap(reader1 -> StreamDeclaration.fromJson(reader1));
                    deserializedDataCollectionRuleResourceProperties.withStreamDeclarations(streamDeclarations);
                    continue;
                }
                if ("dataSources".equals(fieldName)) {
                    deserializedDataCollectionRuleResourceProperties.withDataSources(DataCollectionRuleDataSources.fromJson(reader));
                    continue;
                }
                if ("destinations".equals(fieldName)) {
                    deserializedDataCollectionRuleResourceProperties.withDestinations(DataCollectionRuleDestinations.fromJson(reader));
                    continue;
                }
                if ("dataFlows".equals(fieldName)) {
                    List dataFlows = reader.readArray(reader1 -> DataFlow.fromJson(reader1));
                    deserializedDataCollectionRuleResourceProperties.withDataFlows(dataFlows);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedDataCollectionRuleResourceProperties.provisioningState = KnownDataCollectionRuleProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataCollectionRuleResourceProperties;
        });
    }
}

