/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.LocationThresholdRuleCondition;
import com.azure.resourcemanager.monitor.models.ManagementEventRuleCondition;
import com.azure.resourcemanager.monitor.models.RuleDataSource;
import com.azure.resourcemanager.monitor.models.ThresholdRuleCondition;
import java.io.IOException;

public class RuleCondition
implements JsonSerializable<RuleCondition> {
    private String odataType = "RuleCondition";
    private RuleDataSource dataSource;

    public String odataType() {
        return this.odataType;
    }

    public RuleDataSource dataSource() {
        return this.dataSource;
    }

    public RuleCondition withDataSource(RuleDataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public void validate() {
        if (this.dataSource() != null) {
            this.dataSource().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("odata.type", this.odataType);
        jsonWriter.writeJsonField("dataSource", (JsonSerializable)this.dataSource);
        return jsonWriter.writeEndObject();
    }

    public static RuleCondition fromJson(JsonReader jsonReader) throws IOException {
        return (RuleCondition)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                Object fieldName;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("odata.type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition".equals(discriminatorValue)) {
                    fieldName = ThresholdRuleCondition.fromJson(readerToUse.reset());
                    return fieldName;
                }
                if ("Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition".equals(discriminatorValue)) {
                    fieldName = LocationThresholdRuleCondition.fromJson(readerToUse.reset());
                    return fieldName;
                }
                if ("Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition".equals(discriminatorValue)) {
                    fieldName = ManagementEventRuleCondition.fromJson(readerToUse.reset());
                    return fieldName;
                }
                fieldName = RuleCondition.fromJsonKnownDiscriminator(readerToUse.reset());
                return fieldName;
            }
        });
    }

    static RuleCondition fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (RuleCondition)jsonReader.readObject(reader -> {
            RuleCondition deserializedRuleCondition = new RuleCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("odata.type".equals(fieldName)) {
                    deserializedRuleCondition.odataType = reader.getString();
                    continue;
                }
                if ("dataSource".equals(fieldName)) {
                    deserializedRuleCondition.dataSource = RuleDataSource.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRuleCondition;
        });
    }
}

