/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class MetricAlertAction
implements JsonSerializable<MetricAlertAction> {
    private String actionGroupId;
    private Map<String, String> webhookProperties;

    public String actionGroupId() {
        return this.actionGroupId;
    }

    public MetricAlertAction withActionGroupId(String actionGroupId) {
        this.actionGroupId = actionGroupId;
        return this;
    }

    public Map<String, String> webhookProperties() {
        return this.webhookProperties;
    }

    public MetricAlertAction withWebhookProperties(Map<String, String> webhookProperties) {
        this.webhookProperties = webhookProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("actionGroupId", this.actionGroupId);
        jsonWriter.writeMapField("webHookProperties", this.webhookProperties, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static MetricAlertAction fromJson(JsonReader jsonReader) throws IOException {
        return (MetricAlertAction)jsonReader.readObject(reader -> {
            MetricAlertAction deserializedMetricAlertAction = new MetricAlertAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("actionGroupId".equals(fieldName)) {
                    deserializedMetricAlertAction.actionGroupId = reader.getString();
                    continue;
                }
                if ("webHookProperties".equals(fieldName)) {
                    Map webhookProperties;
                    deserializedMetricAlertAction.webhookProperties = webhookProperties = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricAlertAction;
        });
    }
}

