// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.MetadataValueInner;
import java.io.IOException;
import java.util.List;

/**
 * A time series result type. The discriminator value is always TimeSeries in this case.
 */
@Fluent
public final class TimeSeriesElement implements JsonSerializable<TimeSeriesElement> {
    /*
     * the metadata values returned if $filter was specified in the call.
     */
    private List<MetadataValueInner> metadatavalues;

    /*
     * An array of data points representing the metric values. This is only returned if a result type of data is
     * specified.
     */
    private List<MetricValue> data;

    /**
     * Creates an instance of TimeSeriesElement class.
     */
    public TimeSeriesElement() {
    }

    /**
     * Get the metadatavalues property: the metadata values returned if $filter was specified in the call.
     * 
     * @return the metadatavalues value.
     */
    public List<MetadataValueInner> metadatavalues() {
        return this.metadatavalues;
    }

    /**
     * Set the metadatavalues property: the metadata values returned if $filter was specified in the call.
     * 
     * @param metadatavalues the metadatavalues value to set.
     * @return the TimeSeriesElement object itself.
     */
    public TimeSeriesElement withMetadatavalues(List<MetadataValueInner> metadatavalues) {
        this.metadatavalues = metadatavalues;
        return this;
    }

    /**
     * Get the data property: An array of data points representing the metric values. This is only returned if a result
     * type of data is specified.
     * 
     * @return the data value.
     */
    public List<MetricValue> data() {
        return this.data;
    }

    /**
     * Set the data property: An array of data points representing the metric values. This is only returned if a result
     * type of data is specified.
     * 
     * @param data the data value to set.
     * @return the TimeSeriesElement object itself.
     */
    public TimeSeriesElement withData(List<MetricValue> data) {
        this.data = data;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (metadatavalues() != null) {
            metadatavalues().forEach(e -> e.validate());
        }
        if (data() != null) {
            data().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("metadatavalues", this.metadatavalues,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TimeSeriesElement from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TimeSeriesElement if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the TimeSeriesElement.
     */
    public static TimeSeriesElement fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TimeSeriesElement deserializedTimeSeriesElement = new TimeSeriesElement();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("metadatavalues".equals(fieldName)) {
                    List<MetadataValueInner> metadatavalues
                        = reader.readArray(reader1 -> MetadataValueInner.fromJson(reader1));
                    deserializedTimeSeriesElement.metadatavalues = metadatavalues;
                } else if ("data".equals(fieldName)) {
                    List<MetricValue> data = reader.readArray(reader1 -> MetricValue.fromJson(reader1));
                    deserializedTimeSeriesElement.data = data;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTimeSeriesElement;
        });
    }
}
