// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The log files specific settings.
 */
@Fluent
public final class LogFilesDataSourceSettings extends LogFileSettings {
    /**
     * Creates an instance of LogFilesDataSourceSettings class.
     */
    public LogFilesDataSourceSettings() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public LogFilesDataSourceSettings withText(LogFileSettingsText text) {
        super.withText(text);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("text", text());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LogFilesDataSourceSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LogFilesDataSourceSettings if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the LogFilesDataSourceSettings.
     */
    public static LogFilesDataSourceSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LogFilesDataSourceSettings deserializedLogFilesDataSourceSettings = new LogFilesDataSourceSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("text".equals(fieldName)) {
                    deserializedLogFilesDataSourceSettings.withText(LogFileSettingsText.fromJson(reader));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLogFilesDataSourceSettings;
        });
    }
}
