/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.ActionDetail;
import com.azure.resourcemanager.monitor.models.Context;
import java.io.IOException;
import java.util.List;

public final class TestNotificationDetailsResponseInner
implements JsonSerializable<TestNotificationDetailsResponseInner> {
    private Context context;
    private String state;
    private String completedTime;
    private String createdTime;
    private List<ActionDetail> actionDetails;
    private static final ClientLogger LOGGER = new ClientLogger(TestNotificationDetailsResponseInner.class);

    public Context context() {
        return this.context;
    }

    public TestNotificationDetailsResponseInner withContext(Context context) {
        this.context = context;
        return this;
    }

    public String state() {
        return this.state;
    }

    public TestNotificationDetailsResponseInner withState(String state) {
        this.state = state;
        return this;
    }

    public String completedTime() {
        return this.completedTime;
    }

    public TestNotificationDetailsResponseInner withCompletedTime(String completedTime) {
        this.completedTime = completedTime;
        return this;
    }

    public String createdTime() {
        return this.createdTime;
    }

    public TestNotificationDetailsResponseInner withCreatedTime(String createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    public List<ActionDetail> actionDetails() {
        return this.actionDetails;
    }

    public TestNotificationDetailsResponseInner withActionDetails(List<ActionDetail> actionDetails) {
        this.actionDetails = actionDetails;
        return this;
    }

    public void validate() {
        if (this.context() != null) {
            this.context().validate();
        }
        if (this.state() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property state in model TestNotificationDetailsResponseInner"));
        }
        if (this.actionDetails() != null) {
            this.actionDetails().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state);
        jsonWriter.writeJsonField("context", (JsonSerializable)this.context);
        jsonWriter.writeStringField("completedTime", this.completedTime);
        jsonWriter.writeStringField("createdTime", this.createdTime);
        jsonWriter.writeArrayField("actionDetails", this.actionDetails, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TestNotificationDetailsResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return (TestNotificationDetailsResponseInner)jsonReader.readObject(reader -> {
            TestNotificationDetailsResponseInner deserializedTestNotificationDetailsResponseInner = new TestNotificationDetailsResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("state".equals(fieldName)) {
                    deserializedTestNotificationDetailsResponseInner.state = reader.getString();
                    continue;
                }
                if ("context".equals(fieldName)) {
                    deserializedTestNotificationDetailsResponseInner.context = Context.fromJson(reader);
                    continue;
                }
                if ("completedTime".equals(fieldName)) {
                    deserializedTestNotificationDetailsResponseInner.completedTime = reader.getString();
                    continue;
                }
                if ("createdTime".equals(fieldName)) {
                    deserializedTestNotificationDetailsResponseInner.createdTime = reader.getString();
                    continue;
                }
                if ("actionDetails".equals(fieldName)) {
                    List actionDetails;
                    deserializedTestNotificationDetailsResponseInner.actionDetails = actionDetails = reader.readArray(reader1 -> ActionDetail.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTestNotificationDetailsResponseInner;
        });
    }
}

