/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class IncidentInner
implements JsonSerializable<IncidentInner> {
    private String name;
    private String ruleName;
    private Boolean isActive;
    private OffsetDateTime activatedTime;
    private OffsetDateTime resolvedTime;

    public String name() {
        return this.name;
    }

    public String ruleName() {
        return this.ruleName;
    }

    public Boolean isActive() {
        return this.isActive;
    }

    public OffsetDateTime activatedTime() {
        return this.activatedTime;
    }

    public OffsetDateTime resolvedTime() {
        return this.resolvedTime;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static IncidentInner fromJson(JsonReader jsonReader) throws IOException {
        return (IncidentInner)jsonReader.readObject(reader -> {
            IncidentInner deserializedIncidentInner = new IncidentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedIncidentInner.name = reader.getString();
                    continue;
                }
                if ("ruleName".equals(fieldName)) {
                    deserializedIncidentInner.ruleName = reader.getString();
                    continue;
                }
                if ("isActive".equals(fieldName)) {
                    deserializedIncidentInner.isActive = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("activatedTime".equals(fieldName)) {
                    deserializedIncidentInner.activatedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("resolvedTime".equals(fieldName)) {
                    deserializedIncidentInner.resolvedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIncidentInner;
        });
    }
}

