// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Specifies the metric alert rule criteria for a web test resource.
 */
@Fluent
public final class WebtestLocationAvailabilityCriteria extends MetricAlertCriteria {
    /*
     * specifies the type of the alert criteria.
     */
    private Odatatype odataType = Odatatype.MICROSOFT_AZURE_MONITOR_WEBTEST_LOCATION_AVAILABILITY_CRITERIA;

    /*
     * The Application Insights web test Id.
     */
    private String webTestId;

    /*
     * The Application Insights resource Id.
     */
    private String componentId;

    /*
     * The number of failed locations.
     */
    private float failedLocationCount;

    /**
     * Creates an instance of WebtestLocationAvailabilityCriteria class.
     */
    public WebtestLocationAvailabilityCriteria() {
    }

    /**
     * Get the odataType property: specifies the type of the alert criteria.
     * 
     * @return the odataType value.
     */
    @Override
    public Odatatype odataType() {
        return this.odataType;
    }

    /**
     * Get the webTestId property: The Application Insights web test Id.
     * 
     * @return the webTestId value.
     */
    public String webTestId() {
        return this.webTestId;
    }

    /**
     * Set the webTestId property: The Application Insights web test Id.
     * 
     * @param webTestId the webTestId value to set.
     * @return the WebtestLocationAvailabilityCriteria object itself.
     */
    public WebtestLocationAvailabilityCriteria withWebTestId(String webTestId) {
        this.webTestId = webTestId;
        return this;
    }

    /**
     * Get the componentId property: The Application Insights resource Id.
     * 
     * @return the componentId value.
     */
    public String componentId() {
        return this.componentId;
    }

    /**
     * Set the componentId property: The Application Insights resource Id.
     * 
     * @param componentId the componentId value to set.
     * @return the WebtestLocationAvailabilityCriteria object itself.
     */
    public WebtestLocationAvailabilityCriteria withComponentId(String componentId) {
        this.componentId = componentId;
        return this;
    }

    /**
     * Get the failedLocationCount property: The number of failed locations.
     * 
     * @return the failedLocationCount value.
     */
    public float failedLocationCount() {
        return this.failedLocationCount;
    }

    /**
     * Set the failedLocationCount property: The number of failed locations.
     * 
     * @param failedLocationCount the failedLocationCount value to set.
     * @return the WebtestLocationAvailabilityCriteria object itself.
     */
    public WebtestLocationAvailabilityCriteria withFailedLocationCount(float failedLocationCount) {
        this.failedLocationCount = failedLocationCount;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (webTestId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property webTestId in model WebtestLocationAvailabilityCriteria"));
        }
        if (componentId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property componentId in model WebtestLocationAvailabilityCriteria"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(WebtestLocationAvailabilityCriteria.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("webTestId", this.webTestId);
        jsonWriter.writeStringField("componentId", this.componentId);
        jsonWriter.writeFloatField("failedLocationCount", this.failedLocationCount);
        jsonWriter.writeStringField("odata.type", this.odataType == null ? null : this.odataType.toString());
        if (additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WebtestLocationAvailabilityCriteria from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WebtestLocationAvailabilityCriteria if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the WebtestLocationAvailabilityCriteria.
     */
    public static WebtestLocationAvailabilityCriteria fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WebtestLocationAvailabilityCriteria deserializedWebtestLocationAvailabilityCriteria
                = new WebtestLocationAvailabilityCriteria();
            Map<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("webTestId".equals(fieldName)) {
                    deserializedWebtestLocationAvailabilityCriteria.webTestId = reader.getString();
                } else if ("componentId".equals(fieldName)) {
                    deserializedWebtestLocationAvailabilityCriteria.componentId = reader.getString();
                } else if ("failedLocationCount".equals(fieldName)) {
                    deserializedWebtestLocationAvailabilityCriteria.failedLocationCount = reader.getFloat();
                } else if ("odata.type".equals(fieldName)) {
                    deserializedWebtestLocationAvailabilityCriteria.odataType
                        = Odatatype.fromString(reader.getString());
                } else {
                    if (additionalProperties == null) {
                        additionalProperties = new LinkedHashMap<>();
                    }

                    additionalProperties.put(fieldName, reader.readUntyped());
                }
            }
            deserializedWebtestLocationAvailabilityCriteria.withAdditionalProperties(additionalProperties);

            return deserializedWebtestLocationAvailabilityCriteria;
        });
    }
}
