// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A webhook receiver.
 */
@Fluent
public final class WebhookReceiver implements JsonSerializable<WebhookReceiver> {
    /*
     * The name of the webhook receiver. Names must be unique across all receivers within an action group.
     */
    private String name;

    /*
     * The URI where webhooks should be sent.
     */
    private String serviceUri;

    /*
     * Indicates whether to use common alert schema.
     */
    private Boolean useCommonAlertSchema;

    /*
     * Indicates whether or not use AAD authentication.
     */
    private Boolean useAadAuth;

    /*
     * Indicates the webhook app object Id for aad auth.
     */
    private String objectId;

    /*
     * Indicates the identifier uri for aad auth.
     */
    private String identifierUri;

    /*
     * Indicates the tenant id for aad auth.
     */
    private String tenantId;

    /**
     * Creates an instance of WebhookReceiver class.
     */
    public WebhookReceiver() {
    }

    /**
     * Get the name property: The name of the webhook receiver. Names must be unique across all receivers within an
     * action group.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the webhook receiver. Names must be unique across all receivers within an
     * action group.
     * 
     * @param name the name value to set.
     * @return the WebhookReceiver object itself.
     */
    public WebhookReceiver withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the serviceUri property: The URI where webhooks should be sent.
     * 
     * @return the serviceUri value.
     */
    public String serviceUri() {
        return this.serviceUri;
    }

    /**
     * Set the serviceUri property: The URI where webhooks should be sent.
     * 
     * @param serviceUri the serviceUri value to set.
     * @return the WebhookReceiver object itself.
     */
    public WebhookReceiver withServiceUri(String serviceUri) {
        this.serviceUri = serviceUri;
        return this;
    }

    /**
     * Get the useCommonAlertSchema property: Indicates whether to use common alert schema.
     * 
     * @return the useCommonAlertSchema value.
     */
    public Boolean useCommonAlertSchema() {
        return this.useCommonAlertSchema;
    }

    /**
     * Set the useCommonAlertSchema property: Indicates whether to use common alert schema.
     * 
     * @param useCommonAlertSchema the useCommonAlertSchema value to set.
     * @return the WebhookReceiver object itself.
     */
    public WebhookReceiver withUseCommonAlertSchema(Boolean useCommonAlertSchema) {
        this.useCommonAlertSchema = useCommonAlertSchema;
        return this;
    }

    /**
     * Get the useAadAuth property: Indicates whether or not use AAD authentication.
     * 
     * @return the useAadAuth value.
     */
    public Boolean useAadAuth() {
        return this.useAadAuth;
    }

    /**
     * Set the useAadAuth property: Indicates whether or not use AAD authentication.
     * 
     * @param useAadAuth the useAadAuth value to set.
     * @return the WebhookReceiver object itself.
     */
    public WebhookReceiver withUseAadAuth(Boolean useAadAuth) {
        this.useAadAuth = useAadAuth;
        return this;
    }

    /**
     * Get the objectId property: Indicates the webhook app object Id for aad auth.
     * 
     * @return the objectId value.
     */
    public String objectId() {
        return this.objectId;
    }

    /**
     * Set the objectId property: Indicates the webhook app object Id for aad auth.
     * 
     * @param objectId the objectId value to set.
     * @return the WebhookReceiver object itself.
     */
    public WebhookReceiver withObjectId(String objectId) {
        this.objectId = objectId;
        return this;
    }

    /**
     * Get the identifierUri property: Indicates the identifier uri for aad auth.
     * 
     * @return the identifierUri value.
     */
    public String identifierUri() {
        return this.identifierUri;
    }

    /**
     * Set the identifierUri property: Indicates the identifier uri for aad auth.
     * 
     * @param identifierUri the identifierUri value to set.
     * @return the WebhookReceiver object itself.
     */
    public WebhookReceiver withIdentifierUri(String identifierUri) {
        this.identifierUri = identifierUri;
        return this;
    }

    /**
     * Get the tenantId property: Indicates the tenant id for aad auth.
     * 
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Set the tenantId property: Indicates the tenant id for aad auth.
     * 
     * @param tenantId the tenantId value to set.
     * @return the WebhookReceiver object itself.
     */
    public WebhookReceiver withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model WebhookReceiver"));
        }
        if (serviceUri() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property serviceUri in model WebhookReceiver"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(WebhookReceiver.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("serviceUri", this.serviceUri);
        jsonWriter.writeBooleanField("useCommonAlertSchema", this.useCommonAlertSchema);
        jsonWriter.writeBooleanField("useAadAuth", this.useAadAuth);
        jsonWriter.writeStringField("objectId", this.objectId);
        jsonWriter.writeStringField("identifierUri", this.identifierUri);
        jsonWriter.writeStringField("tenantId", this.tenantId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WebhookReceiver from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WebhookReceiver if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the WebhookReceiver.
     */
    public static WebhookReceiver fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WebhookReceiver deserializedWebhookReceiver = new WebhookReceiver();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedWebhookReceiver.name = reader.getString();
                } else if ("serviceUri".equals(fieldName)) {
                    deserializedWebhookReceiver.serviceUri = reader.getString();
                } else if ("useCommonAlertSchema".equals(fieldName)) {
                    deserializedWebhookReceiver.useCommonAlertSchema = reader.getNullable(JsonReader::getBoolean);
                } else if ("useAadAuth".equals(fieldName)) {
                    deserializedWebhookReceiver.useAadAuth = reader.getNullable(JsonReader::getBoolean);
                } else if ("objectId".equals(fieldName)) {
                    deserializedWebhookReceiver.objectId = reader.getString();
                } else if ("identifierUri".equals(fieldName)) {
                    deserializedWebhookReceiver.identifierUri = reader.getString();
                } else if ("tenantId".equals(fieldName)) {
                    deserializedWebhookReceiver.tenantId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWebhookReceiver;
        });
    }
}
