// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * The baseline values for a single time series.
 */
@Fluent
public final class TimeSeriesBaseline implements JsonSerializable<TimeSeriesBaseline> {
    /*
     * The aggregation type of the metric.
     */
    private String aggregation;

    /*
     * The dimensions of this time series.
     */
    private List<MetricSingleDimension> dimensions;

    /*
     * The list of timestamps of the baselines.
     */
    private List<OffsetDateTime> timestamps;

    /*
     * The baseline values for each sensitivity.
     */
    private List<SingleBaseline> data;

    /*
     * The baseline metadata values.
     */
    private List<BaselineMetadata> metadataValues;

    /**
     * Creates an instance of TimeSeriesBaseline class.
     */
    public TimeSeriesBaseline() {
    }

    /**
     * Get the aggregation property: The aggregation type of the metric.
     * 
     * @return the aggregation value.
     */
    public String aggregation() {
        return this.aggregation;
    }

    /**
     * Set the aggregation property: The aggregation type of the metric.
     * 
     * @param aggregation the aggregation value to set.
     * @return the TimeSeriesBaseline object itself.
     */
    public TimeSeriesBaseline withAggregation(String aggregation) {
        this.aggregation = aggregation;
        return this;
    }

    /**
     * Get the dimensions property: The dimensions of this time series.
     * 
     * @return the dimensions value.
     */
    public List<MetricSingleDimension> dimensions() {
        return this.dimensions;
    }

    /**
     * Set the dimensions property: The dimensions of this time series.
     * 
     * @param dimensions the dimensions value to set.
     * @return the TimeSeriesBaseline object itself.
     */
    public TimeSeriesBaseline withDimensions(List<MetricSingleDimension> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    /**
     * Get the timestamps property: The list of timestamps of the baselines.
     * 
     * @return the timestamps value.
     */
    public List<OffsetDateTime> timestamps() {
        return this.timestamps;
    }

    /**
     * Set the timestamps property: The list of timestamps of the baselines.
     * 
     * @param timestamps the timestamps value to set.
     * @return the TimeSeriesBaseline object itself.
     */
    public TimeSeriesBaseline withTimestamps(List<OffsetDateTime> timestamps) {
        this.timestamps = timestamps;
        return this;
    }

    /**
     * Get the data property: The baseline values for each sensitivity.
     * 
     * @return the data value.
     */
    public List<SingleBaseline> data() {
        return this.data;
    }

    /**
     * Set the data property: The baseline values for each sensitivity.
     * 
     * @param data the data value to set.
     * @return the TimeSeriesBaseline object itself.
     */
    public TimeSeriesBaseline withData(List<SingleBaseline> data) {
        this.data = data;
        return this;
    }

    /**
     * Get the metadataValues property: The baseline metadata values.
     * 
     * @return the metadataValues value.
     */
    public List<BaselineMetadata> metadataValues() {
        return this.metadataValues;
    }

    /**
     * Set the metadataValues property: The baseline metadata values.
     * 
     * @param metadataValues the metadataValues value to set.
     * @return the TimeSeriesBaseline object itself.
     */
    public TimeSeriesBaseline withMetadataValues(List<BaselineMetadata> metadataValues) {
        this.metadataValues = metadataValues;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (aggregation() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property aggregation in model TimeSeriesBaseline"));
        }
        if (dimensions() != null) {
            dimensions().forEach(e -> e.validate());
        }
        if (timestamps() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property timestamps in model TimeSeriesBaseline"));
        }
        if (data() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property data in model TimeSeriesBaseline"));
        } else {
            data().forEach(e -> e.validate());
        }
        if (metadataValues() != null) {
            metadataValues().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(TimeSeriesBaseline.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("aggregation", this.aggregation);
        jsonWriter.writeArrayField("timestamps", this.timestamps, (writer, element) -> writer
            .writeString(element == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(element)));
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("dimensions", this.dimensions, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("metadataValues", this.metadataValues,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of TimeSeriesBaseline from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of TimeSeriesBaseline if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the TimeSeriesBaseline.
     */
    public static TimeSeriesBaseline fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            TimeSeriesBaseline deserializedTimeSeriesBaseline = new TimeSeriesBaseline();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("aggregation".equals(fieldName)) {
                    deserializedTimeSeriesBaseline.aggregation = reader.getString();
                } else if ("timestamps".equals(fieldName)) {
                    List<OffsetDateTime> timestamps = reader.readArray(reader1 -> reader1
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                    deserializedTimeSeriesBaseline.timestamps = timestamps;
                } else if ("data".equals(fieldName)) {
                    List<SingleBaseline> data = reader.readArray(reader1 -> SingleBaseline.fromJson(reader1));
                    deserializedTimeSeriesBaseline.data = data;
                } else if ("dimensions".equals(fieldName)) {
                    List<MetricSingleDimension> dimensions
                        = reader.readArray(reader1 -> MetricSingleDimension.fromJson(reader1));
                    deserializedTimeSeriesBaseline.dimensions = dimensions;
                } else if ("metadataValues".equals(fieldName)) {
                    List<BaselineMetadata> metadataValues
                        = reader.readArray(reader1 -> BaselineMetadata.fromJson(reader1));
                    deserializedTimeSeriesBaseline.metadataValues = metadataValues;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedTimeSeriesBaseline;
        });
    }
}
