// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;

/**
 * A rule condition based on a metric crossing a threshold.
 */
@Fluent
public final class ThresholdRuleCondition extends RuleCondition {
    /*
     * specifies the type of condition. This can be one of three types: ManagementEventRuleCondition (occurrences of
     * management events), LocationThresholdRuleCondition (based on the number of failures of a web test), and
     * ThresholdRuleCondition (based on the threshold of a metric).
     */
    private String odataType = "Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition";

    /*
     * the operator used to compare the data and the threshold.
     */
    private ConditionOperator operator;

    /*
     * the threshold value that activates the alert.
     */
    private double threshold;

    /*
     * the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold.
     * If specified then it must be between 5 minutes and 1 day.
     */
    private Duration windowSize;

    /*
     * the time aggregation operator. How the data that are collected should be combined over time. The default value is
     * the PrimaryAggregationType of the Metric.
     */
    private TimeAggregationOperator timeAggregation;

    /**
     * Creates an instance of ThresholdRuleCondition class.
     */
    public ThresholdRuleCondition() {
    }

    /**
     * Get the odataType property: specifies the type of condition. This can be one of three types:
     * ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition (based on the
     * number of failures of a web test), and ThresholdRuleCondition (based on the threshold of a metric).
     * 
     * @return the odataType value.
     */
    @Override
    public String odataType() {
        return this.odataType;
    }

    /**
     * Get the operator property: the operator used to compare the data and the threshold.
     * 
     * @return the operator value.
     */
    public ConditionOperator operator() {
        return this.operator;
    }

    /**
     * Set the operator property: the operator used to compare the data and the threshold.
     * 
     * @param operator the operator value to set.
     * @return the ThresholdRuleCondition object itself.
     */
    public ThresholdRuleCondition withOperator(ConditionOperator operator) {
        this.operator = operator;
        return this;
    }

    /**
     * Get the threshold property: the threshold value that activates the alert.
     * 
     * @return the threshold value.
     */
    public double threshold() {
        return this.threshold;
    }

    /**
     * Set the threshold property: the threshold value that activates the alert.
     * 
     * @param threshold the threshold value to set.
     * @return the ThresholdRuleCondition object itself.
     */
    public ThresholdRuleCondition withThreshold(double threshold) {
        this.threshold = threshold;
        return this;
    }

    /**
     * Get the windowSize property: the period of time (in ISO 8601 duration format) that is used to monitor alert
     * activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
     * 
     * @return the windowSize value.
     */
    public Duration windowSize() {
        return this.windowSize;
    }

    /**
     * Set the windowSize property: the period of time (in ISO 8601 duration format) that is used to monitor alert
     * activity based on the threshold. If specified then it must be between 5 minutes and 1 day.
     * 
     * @param windowSize the windowSize value to set.
     * @return the ThresholdRuleCondition object itself.
     */
    public ThresholdRuleCondition withWindowSize(Duration windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    /**
     * Get the timeAggregation property: the time aggregation operator. How the data that are collected should be
     * combined over time. The default value is the PrimaryAggregationType of the Metric.
     * 
     * @return the timeAggregation value.
     */
    public TimeAggregationOperator timeAggregation() {
        return this.timeAggregation;
    }

    /**
     * Set the timeAggregation property: the time aggregation operator. How the data that are collected should be
     * combined over time. The default value is the PrimaryAggregationType of the Metric.
     * 
     * @param timeAggregation the timeAggregation value to set.
     * @return the ThresholdRuleCondition object itself.
     */
    public ThresholdRuleCondition withTimeAggregation(TimeAggregationOperator timeAggregation) {
        this.timeAggregation = timeAggregation;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ThresholdRuleCondition withDataSource(RuleDataSource dataSource) {
        super.withDataSource(dataSource);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (operator() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property operator in model ThresholdRuleCondition"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ThresholdRuleCondition.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("dataSource", dataSource());
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeDoubleField("threshold", this.threshold);
        jsonWriter.writeStringField("odata.type", this.odataType);
        jsonWriter.writeStringField("windowSize", CoreUtils.durationToStringWithDays(this.windowSize));
        jsonWriter.writeStringField("timeAggregation",
            this.timeAggregation == null ? null : this.timeAggregation.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ThresholdRuleCondition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ThresholdRuleCondition if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ThresholdRuleCondition.
     */
    public static ThresholdRuleCondition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ThresholdRuleCondition deserializedThresholdRuleCondition = new ThresholdRuleCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("dataSource".equals(fieldName)) {
                    deserializedThresholdRuleCondition.withDataSource(RuleDataSource.fromJson(reader));
                } else if ("operator".equals(fieldName)) {
                    deserializedThresholdRuleCondition.operator = ConditionOperator.fromString(reader.getString());
                } else if ("threshold".equals(fieldName)) {
                    deserializedThresholdRuleCondition.threshold = reader.getDouble();
                } else if ("odata.type".equals(fieldName)) {
                    deserializedThresholdRuleCondition.odataType = reader.getString();
                } else if ("windowSize".equals(fieldName)) {
                    deserializedThresholdRuleCondition.windowSize
                        = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                } else if ("timeAggregation".equals(fieldName)) {
                    deserializedThresholdRuleCondition.timeAggregation
                        = TimeAggregationOperator.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedThresholdRuleCondition;
        });
    }
}
