// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * An alert action.
 */
@Fluent
public final class MetricAlertAction implements JsonSerializable<MetricAlertAction> {
    /*
     * the id of the action group to use.
     */
    private String actionGroupId;

    /*
     * This field allows specifying custom properties, which would be appended to the alert payload sent as input to the
     * webhook.
     */
    private Map<String, String> webhookProperties;

    /**
     * Creates an instance of MetricAlertAction class.
     */
    public MetricAlertAction() {
    }

    /**
     * Get the actionGroupId property: the id of the action group to use.
     * 
     * @return the actionGroupId value.
     */
    public String actionGroupId() {
        return this.actionGroupId;
    }

    /**
     * Set the actionGroupId property: the id of the action group to use.
     * 
     * @param actionGroupId the actionGroupId value to set.
     * @return the MetricAlertAction object itself.
     */
    public MetricAlertAction withActionGroupId(String actionGroupId) {
        this.actionGroupId = actionGroupId;
        return this;
    }

    /**
     * Get the webhookProperties property: This field allows specifying custom properties, which would be appended to
     * the alert payload sent as input to the webhook.
     * 
     * @return the webhookProperties value.
     */
    public Map<String, String> webhookProperties() {
        return this.webhookProperties;
    }

    /**
     * Set the webhookProperties property: This field allows specifying custom properties, which would be appended to
     * the alert payload sent as input to the webhook.
     * 
     * @param webhookProperties the webhookProperties value to set.
     * @return the MetricAlertAction object itself.
     */
    public MetricAlertAction withWebhookProperties(Map<String, String> webhookProperties) {
        this.webhookProperties = webhookProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("actionGroupId", this.actionGroupId);
        jsonWriter.writeMapField("webHookProperties", this.webhookProperties,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MetricAlertAction from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MetricAlertAction if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MetricAlertAction.
     */
    public static MetricAlertAction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricAlertAction deserializedMetricAlertAction = new MetricAlertAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("actionGroupId".equals(fieldName)) {
                    deserializedMetricAlertAction.actionGroupId = reader.getString();
                } else if ("webHookProperties".equals(fieldName)) {
                    Map<String, String> webhookProperties = reader.readMap(reader1 -> reader1.getString());
                    deserializedMetricAlertAction.webhookProperties = webhookProperties;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMetricAlertAction;
        });
    }
}
