// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A logic app receiver.
 */
@Fluent
public final class LogicAppReceiver implements JsonSerializable<LogicAppReceiver> {
    /*
     * The name of the logic app receiver. Names must be unique across all receivers within an action group.
     */
    private String name;

    /*
     * The azure resource id of the logic app receiver.
     */
    private String resourceId;

    /*
     * The callback url where http request sent to.
     */
    private String callbackUrl;

    /*
     * Indicates whether to use common alert schema.
     */
    private Boolean useCommonAlertSchema;

    /**
     * Creates an instance of LogicAppReceiver class.
     */
    public LogicAppReceiver() {
    }

    /**
     * Get the name property: The name of the logic app receiver. Names must be unique across all receivers within an
     * action group.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the logic app receiver. Names must be unique across all receivers within an
     * action group.
     * 
     * @param name the name value to set.
     * @return the LogicAppReceiver object itself.
     */
    public LogicAppReceiver withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the resourceId property: The azure resource id of the logic app receiver.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: The azure resource id of the logic app receiver.
     * 
     * @param resourceId the resourceId value to set.
     * @return the LogicAppReceiver object itself.
     */
    public LogicAppReceiver withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the callbackUrl property: The callback url where http request sent to.
     * 
     * @return the callbackUrl value.
     */
    public String callbackUrl() {
        return this.callbackUrl;
    }

    /**
     * Set the callbackUrl property: The callback url where http request sent to.
     * 
     * @param callbackUrl the callbackUrl value to set.
     * @return the LogicAppReceiver object itself.
     */
    public LogicAppReceiver withCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    /**
     * Get the useCommonAlertSchema property: Indicates whether to use common alert schema.
     * 
     * @return the useCommonAlertSchema value.
     */
    public Boolean useCommonAlertSchema() {
        return this.useCommonAlertSchema;
    }

    /**
     * Set the useCommonAlertSchema property: Indicates whether to use common alert schema.
     * 
     * @param useCommonAlertSchema the useCommonAlertSchema value to set.
     * @return the LogicAppReceiver object itself.
     */
    public LogicAppReceiver withUseCommonAlertSchema(Boolean useCommonAlertSchema) {
        this.useCommonAlertSchema = useCommonAlertSchema;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model LogicAppReceiver"));
        }
        if (resourceId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property resourceId in model LogicAppReceiver"));
        }
        if (callbackUrl() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property callbackUrl in model LogicAppReceiver"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LogicAppReceiver.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("callbackUrl", this.callbackUrl);
        jsonWriter.writeBooleanField("useCommonAlertSchema", this.useCommonAlertSchema);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LogicAppReceiver from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LogicAppReceiver if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LogicAppReceiver.
     */
    public static LogicAppReceiver fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LogicAppReceiver deserializedLogicAppReceiver = new LogicAppReceiver();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedLogicAppReceiver.name = reader.getString();
                } else if ("resourceId".equals(fieldName)) {
                    deserializedLogicAppReceiver.resourceId = reader.getString();
                } else if ("callbackUrl".equals(fieldName)) {
                    deserializedLogicAppReceiver.callbackUrl = reader.getString();
                } else if ("useCommonAlertSchema".equals(fieldName)) {
                    deserializedLogicAppReceiver.useCommonAlertSchema = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLogicAppReceiver;
        });
    }
}
