// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.LogProfileResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * Represents a collection of log profiles.
 */
@Fluent
public final class LogProfileCollection implements JsonSerializable<LogProfileCollection> {
    /*
     * the values of the log profiles.
     */
    private List<LogProfileResourceInner> value;

    /**
     * Creates an instance of LogProfileCollection class.
     */
    public LogProfileCollection() {
    }

    /**
     * Get the value property: the values of the log profiles.
     * 
     * @return the value value.
     */
    public List<LogProfileResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: the values of the log profiles.
     * 
     * @param value the value value to set.
     * @return the LogProfileCollection object itself.
     */
    public LogProfileCollection withValue(List<LogProfileResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model LogProfileCollection"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LogProfileCollection.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LogProfileCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LogProfileCollection if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LogProfileCollection.
     */
    public static LogProfileCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LogProfileCollection deserializedLogProfileCollection = new LogProfileCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<LogProfileResourceInner> value
                        = reader.readArray(reader1 -> LogProfileResourceInner.fromJson(reader1));
                    deserializedLogProfileCollection.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLogProfileCollection;
        });
    }
}
