// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The endpoint used by clients to ingest logs.
 */
@Immutable
public final class DataCollectionEndpointLogsIngestion extends LogsIngestionEndpointSpec {
    /*
     * The endpoint. This property is READ-ONLY.
     */
    private String endpoint;

    /**
     * Creates an instance of DataCollectionEndpointLogsIngestion class.
     */
    public DataCollectionEndpointLogsIngestion() {
    }

    /**
     * Get the endpoint property: The endpoint. This property is READ-ONLY.
     * 
     * @return the endpoint value.
     */
    @Override
    public String endpoint() {
        return this.endpoint;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataCollectionEndpointLogsIngestion from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataCollectionEndpointLogsIngestion if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DataCollectionEndpointLogsIngestion.
     */
    public static DataCollectionEndpointLogsIngestion fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataCollectionEndpointLogsIngestion deserializedDataCollectionEndpointLogsIngestion
                = new DataCollectionEndpointLogsIngestion();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("endpoint".equals(fieldName)) {
                    deserializedDataCollectionEndpointLogsIngestion.endpoint = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataCollectionEndpointLogsIngestion;
        });
    }
}
