// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Definition of data collection endpoint.
 */
@Fluent
public class DataCollectionEndpoint implements JsonSerializable<DataCollectionEndpoint> {
    /*
     * Description of the data collection endpoint.
     */
    private String description;

    /*
     * The immutable ID of this data collection endpoint resource. This property is READ-ONLY.
     */
    private String immutableId;

    /*
     * The endpoint used by clients to access their configuration.
     */
    private DataCollectionEndpointConfigurationAccess configurationAccess;

    /*
     * The endpoint used by clients to ingest logs.
     */
    private DataCollectionEndpointLogsIngestion logsIngestion;

    /*
     * Network access control rules for the endpoints.
     */
    private DataCollectionEndpointNetworkAcls networkAcls;

    /*
     * The resource provisioning state. This property is READ-ONLY.
     */
    private KnownDataCollectionEndpointProvisioningState provisioningState;

    /**
     * Creates an instance of DataCollectionEndpoint class.
     */
    public DataCollectionEndpoint() {
    }

    /**
     * Get the description property: Description of the data collection endpoint.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the data collection endpoint.
     * 
     * @param description the description value to set.
     * @return the DataCollectionEndpoint object itself.
     */
    public DataCollectionEndpoint withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the immutableId property: The immutable ID of this data collection endpoint resource. This property is
     * READ-ONLY.
     * 
     * @return the immutableId value.
     */
    public String immutableId() {
        return this.immutableId;
    }

    /**
     * Set the immutableId property: The immutable ID of this data collection endpoint resource. This property is
     * READ-ONLY.
     * 
     * @param immutableId the immutableId value to set.
     * @return the DataCollectionEndpoint object itself.
     */
    public DataCollectionEndpoint withImmutableId(String immutableId) {
        this.immutableId = immutableId;
        return this;
    }

    /**
     * Get the configurationAccess property: The endpoint used by clients to access their configuration.
     * 
     * @return the configurationAccess value.
     */
    public DataCollectionEndpointConfigurationAccess configurationAccess() {
        return this.configurationAccess;
    }

    /**
     * Set the configurationAccess property: The endpoint used by clients to access their configuration.
     * 
     * @param configurationAccess the configurationAccess value to set.
     * @return the DataCollectionEndpoint object itself.
     */
    public DataCollectionEndpoint
        withConfigurationAccess(DataCollectionEndpointConfigurationAccess configurationAccess) {
        this.configurationAccess = configurationAccess;
        return this;
    }

    /**
     * Get the logsIngestion property: The endpoint used by clients to ingest logs.
     * 
     * @return the logsIngestion value.
     */
    public DataCollectionEndpointLogsIngestion logsIngestion() {
        return this.logsIngestion;
    }

    /**
     * Set the logsIngestion property: The endpoint used by clients to ingest logs.
     * 
     * @param logsIngestion the logsIngestion value to set.
     * @return the DataCollectionEndpoint object itself.
     */
    public DataCollectionEndpoint withLogsIngestion(DataCollectionEndpointLogsIngestion logsIngestion) {
        this.logsIngestion = logsIngestion;
        return this;
    }

    /**
     * Get the networkAcls property: Network access control rules for the endpoints.
     * 
     * @return the networkAcls value.
     */
    public DataCollectionEndpointNetworkAcls networkAcls() {
        return this.networkAcls;
    }

    /**
     * Set the networkAcls property: Network access control rules for the endpoints.
     * 
     * @param networkAcls the networkAcls value to set.
     * @return the DataCollectionEndpoint object itself.
     */
    public DataCollectionEndpoint withNetworkAcls(DataCollectionEndpointNetworkAcls networkAcls) {
        this.networkAcls = networkAcls;
        return this;
    }

    /**
     * Get the provisioningState property: The resource provisioning state. This property is READ-ONLY.
     * 
     * @return the provisioningState value.
     */
    public KnownDataCollectionEndpointProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState property: The resource provisioning state. This property is READ-ONLY.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the DataCollectionEndpoint object itself.
     */
    DataCollectionEndpoint withProvisioningState(KnownDataCollectionEndpointProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (configurationAccess() != null) {
            configurationAccess().validate();
        }
        if (logsIngestion() != null) {
            logsIngestion().validate();
        }
        if (networkAcls() != null) {
            networkAcls().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("immutableId", this.immutableId);
        jsonWriter.writeJsonField("configurationAccess", this.configurationAccess);
        jsonWriter.writeJsonField("logsIngestion", this.logsIngestion);
        jsonWriter.writeJsonField("networkAcls", this.networkAcls);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataCollectionEndpoint from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataCollectionEndpoint if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DataCollectionEndpoint.
     */
    public static DataCollectionEndpoint fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataCollectionEndpoint deserializedDataCollectionEndpoint = new DataCollectionEndpoint();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedDataCollectionEndpoint.description = reader.getString();
                } else if ("immutableId".equals(fieldName)) {
                    deserializedDataCollectionEndpoint.immutableId = reader.getString();
                } else if ("configurationAccess".equals(fieldName)) {
                    deserializedDataCollectionEndpoint.configurationAccess
                        = DataCollectionEndpointConfigurationAccess.fromJson(reader);
                } else if ("logsIngestion".equals(fieldName)) {
                    deserializedDataCollectionEndpoint.logsIngestion
                        = DataCollectionEndpointLogsIngestion.fromJson(reader);
                } else if ("networkAcls".equals(fieldName)) {
                    deserializedDataCollectionEndpoint.networkAcls = DataCollectionEndpointNetworkAcls.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedDataCollectionEndpoint.provisioningState
                        = KnownDataCollectionEndpointProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataCollectionEndpoint;
        });
    }
}
