// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.TimeSeriesBaseline;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

/**
 * The baseline results of a single metric.
 */
@Fluent
public final class SingleMetricBaselineInner implements JsonSerializable<SingleMetricBaselineInner> {
    /*
     * The metric baseline Id.
     */
    private String id;

    /*
     * The resource type of the metric baseline resource.
     */
    private String type;

    /*
     * The name of the metric for which the baselines were retrieved.
     */
    private String name;

    /*
     * The metric baseline properties of the metric.
     */
    private MetricBaselinesProperties innerProperties = new MetricBaselinesProperties();

    /**
     * Creates an instance of SingleMetricBaselineInner class.
     */
    public SingleMetricBaselineInner() {
    }

    /**
     * Get the id property: The metric baseline Id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The metric baseline Id.
     * 
     * @param id the id value to set.
     * @return the SingleMetricBaselineInner object itself.
     */
    public SingleMetricBaselineInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the type property: The resource type of the metric baseline resource.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The resource type of the metric baseline resource.
     * 
     * @param type the type value to set.
     * @return the SingleMetricBaselineInner object itself.
     */
    public SingleMetricBaselineInner withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the name property: The name of the metric for which the baselines were retrieved.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the metric for which the baselines were retrieved.
     * 
     * @param name the name value to set.
     * @return the SingleMetricBaselineInner object itself.
     */
    public SingleMetricBaselineInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the innerProperties property: The metric baseline properties of the metric.
     * 
     * @return the innerProperties value.
     */
    private MetricBaselinesProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the timespan property: The timespan for which the data was retrieved. Its value consists of two datetimes
     * concatenated, separated by '/'. This may be adjusted in the future and returned back from what was originally
     * requested.
     * 
     * @return the timespan value.
     */
    public String timespan() {
        return this.innerProperties() == null ? null : this.innerProperties().timespan();
    }

    /**
     * Set the timespan property: The timespan for which the data was retrieved. Its value consists of two datetimes
     * concatenated, separated by '/'. This may be adjusted in the future and returned back from what was originally
     * requested.
     * 
     * @param timespan the timespan value to set.
     * @return the SingleMetricBaselineInner object itself.
     */
    public SingleMetricBaselineInner withTimespan(String timespan) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricBaselinesProperties();
        }
        this.innerProperties().withTimespan(timespan);
        return this;
    }

    /**
     * Get the interval property: The interval (window size) for which the metric data was returned in. This may be
     * adjusted in the future and returned back from what was originally requested. This is not present if a metadata
     * request was made.
     * 
     * @return the interval value.
     */
    public Duration interval() {
        return this.innerProperties() == null ? null : this.innerProperties().interval();
    }

    /**
     * Set the interval property: The interval (window size) for which the metric data was returned in. This may be
     * adjusted in the future and returned back from what was originally requested. This is not present if a metadata
     * request was made.
     * 
     * @param interval the interval value to set.
     * @return the SingleMetricBaselineInner object itself.
     */
    public SingleMetricBaselineInner withInterval(Duration interval) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricBaselinesProperties();
        }
        this.innerProperties().withInterval(interval);
        return this;
    }

    /**
     * Get the namespace property: The namespace of the metrics been queried.
     * 
     * @return the namespace value.
     */
    public String namespace() {
        return this.innerProperties() == null ? null : this.innerProperties().namespace();
    }

    /**
     * Set the namespace property: The namespace of the metrics been queried.
     * 
     * @param namespace the namespace value to set.
     * @return the SingleMetricBaselineInner object itself.
     */
    public SingleMetricBaselineInner withNamespace(String namespace) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricBaselinesProperties();
        }
        this.innerProperties().withNamespace(namespace);
        return this;
    }

    /**
     * Get the baselines property: The baseline for each time series that was queried.
     * 
     * @return the baselines value.
     */
    public List<TimeSeriesBaseline> baselines() {
        return this.innerProperties() == null ? null : this.innerProperties().baselines();
    }

    /**
     * Set the baselines property: The baseline for each time series that was queried.
     * 
     * @param baselines the baselines value to set.
     * @return the SingleMetricBaselineInner object itself.
     */
    public SingleMetricBaselineInner withBaselines(List<TimeSeriesBaseline> baselines) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MetricBaselinesProperties();
        }
        this.innerProperties().withBaselines(baselines);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property id in model SingleMetricBaselineInner"));
        }
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property type in model SingleMetricBaselineInner"));
        }
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model SingleMetricBaselineInner"));
        }
        if (innerProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerProperties in model SingleMetricBaselineInner"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SingleMetricBaselineInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SingleMetricBaselineInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SingleMetricBaselineInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SingleMetricBaselineInner.
     */
    public static SingleMetricBaselineInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SingleMetricBaselineInner deserializedSingleMetricBaselineInner = new SingleMetricBaselineInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSingleMetricBaselineInner.id = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSingleMetricBaselineInner.type = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedSingleMetricBaselineInner.name = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedSingleMetricBaselineInner.innerProperties = MetricBaselinesProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSingleMetricBaselineInner;
        });
    }
}
