// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of a private link scoped resource.
 */
@Fluent
public final class ScopedResourceProperties implements JsonSerializable<ScopedResourceProperties> {
    /*
     * The resource id of the scoped Azure monitor resource.
     */
    private String linkedResourceId;

    /*
     * State of the private endpoint connection.
     */
    private String provisioningState;

    /**
     * Creates an instance of ScopedResourceProperties class.
     */
    public ScopedResourceProperties() {
    }

    /**
     * Get the linkedResourceId property: The resource id of the scoped Azure monitor resource.
     * 
     * @return the linkedResourceId value.
     */
    public String linkedResourceId() {
        return this.linkedResourceId;
    }

    /**
     * Set the linkedResourceId property: The resource id of the scoped Azure monitor resource.
     * 
     * @param linkedResourceId the linkedResourceId value to set.
     * @return the ScopedResourceProperties object itself.
     */
    public ScopedResourceProperties withLinkedResourceId(String linkedResourceId) {
        this.linkedResourceId = linkedResourceId;
        return this;
    }

    /**
     * Get the provisioningState property: State of the private endpoint connection.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("linkedResourceId", this.linkedResourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScopedResourceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScopedResourceProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ScopedResourceProperties.
     */
    public static ScopedResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScopedResourceProperties deserializedScopedResourceProperties = new ScopedResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("linkedResourceId".equals(fieldName)) {
                    deserializedScopedResourceProperties.linkedResourceId = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedScopedResourceProperties.provisioningState = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedScopedResourceProperties;
        });
    }
}
