// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.PredictiveValue;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

/**
 * The response to a metrics query.
 */
@Fluent
public final class PredictiveResponseInner implements JsonSerializable<PredictiveResponseInner> {
    /*
     * The timespan for which the data was retrieved. Its value consists of two datetimes concatenated, separated by
     * '/'. This may be adjusted in the future and returned back from what was originally requested.
     */
    private String timespan;

    /*
     * The interval (window size) for which the metric data was returned in. This may be adjusted in the future and
     * returned back from what was originally requested. This is not present if a metadata request was made.
     */
    private Duration interval;

    /*
     * The metrics being queried
     */
    private String metricName;

    /*
     * resource of the predictive metric.
     */
    private String targetResourceId;

    /*
     * the value of the collection.
     */
    private List<PredictiveValue> data;

    /**
     * Creates an instance of PredictiveResponseInner class.
     */
    public PredictiveResponseInner() {
    }

    /**
     * Get the timespan property: The timespan for which the data was retrieved. Its value consists of two datetimes
     * concatenated, separated by '/'. This may be adjusted in the future and returned back from what was originally
     * requested.
     * 
     * @return the timespan value.
     */
    public String timespan() {
        return this.timespan;
    }

    /**
     * Set the timespan property: The timespan for which the data was retrieved. Its value consists of two datetimes
     * concatenated, separated by '/'. This may be adjusted in the future and returned back from what was originally
     * requested.
     * 
     * @param timespan the timespan value to set.
     * @return the PredictiveResponseInner object itself.
     */
    public PredictiveResponseInner withTimespan(String timespan) {
        this.timespan = timespan;
        return this;
    }

    /**
     * Get the interval property: The interval (window size) for which the metric data was returned in. This may be
     * adjusted in the future and returned back from what was originally requested. This is not present if a metadata
     * request was made.
     * 
     * @return the interval value.
     */
    public Duration interval() {
        return this.interval;
    }

    /**
     * Set the interval property: The interval (window size) for which the metric data was returned in. This may be
     * adjusted in the future and returned back from what was originally requested. This is not present if a metadata
     * request was made.
     * 
     * @param interval the interval value to set.
     * @return the PredictiveResponseInner object itself.
     */
    public PredictiveResponseInner withInterval(Duration interval) {
        this.interval = interval;
        return this;
    }

    /**
     * Get the metricName property: The metrics being queried.
     * 
     * @return the metricName value.
     */
    public String metricName() {
        return this.metricName;
    }

    /**
     * Set the metricName property: The metrics being queried.
     * 
     * @param metricName the metricName value to set.
     * @return the PredictiveResponseInner object itself.
     */
    public PredictiveResponseInner withMetricName(String metricName) {
        this.metricName = metricName;
        return this;
    }

    /**
     * Get the targetResourceId property: resource of the predictive metric.
     * 
     * @return the targetResourceId value.
     */
    public String targetResourceId() {
        return this.targetResourceId;
    }

    /**
     * Set the targetResourceId property: resource of the predictive metric.
     * 
     * @param targetResourceId the targetResourceId value to set.
     * @return the PredictiveResponseInner object itself.
     */
    public PredictiveResponseInner withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    /**
     * Get the data property: the value of the collection.
     * 
     * @return the data value.
     */
    public List<PredictiveValue> data() {
        return this.data;
    }

    /**
     * Set the data property: the value of the collection.
     * 
     * @param data the data value to set.
     * @return the PredictiveResponseInner object itself.
     */
    public PredictiveResponseInner withData(List<PredictiveValue> data) {
        this.data = data;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (data() != null) {
            data().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timespan", this.timespan);
        jsonWriter.writeStringField("interval", CoreUtils.durationToStringWithDays(this.interval));
        jsonWriter.writeStringField("metricName", this.metricName);
        jsonWriter.writeStringField("targetResourceId", this.targetResourceId);
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PredictiveResponseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PredictiveResponseInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PredictiveResponseInner.
     */
    public static PredictiveResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PredictiveResponseInner deserializedPredictiveResponseInner = new PredictiveResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("timespan".equals(fieldName)) {
                    deserializedPredictiveResponseInner.timespan = reader.getString();
                } else if ("interval".equals(fieldName)) {
                    deserializedPredictiveResponseInner.interval
                        = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                } else if ("metricName".equals(fieldName)) {
                    deserializedPredictiveResponseInner.metricName = reader.getString();
                } else if ("targetResourceId".equals(fieldName)) {
                    deserializedPredictiveResponseInner.targetResourceId = reader.getString();
                } else if ("data".equals(fieldName)) {
                    List<PredictiveValue> data = reader.readArray(reader1 -> PredictiveValue.fromJson(reader1));
                    deserializedPredictiveResponseInner.data = data;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPredictiveResponseInner;
        });
    }
}
