// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.MetricAlertAction;
import com.azure.resourcemanager.monitor.models.MetricAlertCriteria;
import java.io.IOException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * An alert rule.
 */
@Fluent
public final class MetricAlertProperties implements JsonSerializable<MetricAlertProperties> {
    /*
     * the description of the metric alert that will be included in the alert email.
     */
    private String description;

    /*
     * Alert severity {0, 1, 2, 3, 4}
     */
    private int severity;

    /*
     * the flag that indicates whether the metric alert is enabled.
     */
    private boolean enabled;

    /*
     * the list of resource id's that this metric alert is scoped to.
     */
    private List<String> scopes;

    /*
     * how often the metric alert is evaluated represented in ISO 8601 duration format.
     */
    private Duration evaluationFrequency;

    /*
     * the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold.
     */
    private Duration windowSize;

    /*
     * the resource type of the target resource(s) on which the alert is created/updated. Mandatory if the scope
     * contains a subscription, resource group, or more than one resource.
     */
    private String targetResourceType;

    /*
     * the region of the target resource(s) on which the alert is created/updated. Mandatory if the scope contains a
     * subscription, resource group, or more than one resource.
     */
    private String targetResourceRegion;

    /*
     * defines the specific alert criteria information.
     */
    private MetricAlertCriteria criteria;

    /*
     * the flag that indicates whether the alert should be auto resolved or not. The default is true.
     */
    private Boolean autoMitigate;

    /*
     * the array of actions that are performed when the alert rule becomes active, and when an alert condition is
     * resolved.
     */
    private List<MetricAlertAction> actions;

    /*
     * Last time the rule was updated in ISO8601 format.
     */
    private OffsetDateTime lastUpdatedTime;

    /*
     * the value indicating whether this alert rule is migrated.
     */
    private Boolean isMigrated;

    /**
     * Creates an instance of MetricAlertProperties class.
     */
    public MetricAlertProperties() {
    }

    /**
     * Get the description property: the description of the metric alert that will be included in the alert email.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: the description of the metric alert that will be included in the alert email.
     * 
     * @param description the description value to set.
     * @return the MetricAlertProperties object itself.
     */
    public MetricAlertProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the severity property: Alert severity {0, 1, 2, 3, 4}.
     * 
     * @return the severity value.
     */
    public int severity() {
        return this.severity;
    }

    /**
     * Set the severity property: Alert severity {0, 1, 2, 3, 4}.
     * 
     * @param severity the severity value to set.
     * @return the MetricAlertProperties object itself.
     */
    public MetricAlertProperties withSeverity(int severity) {
        this.severity = severity;
        return this;
    }

    /**
     * Get the enabled property: the flag that indicates whether the metric alert is enabled.
     * 
     * @return the enabled value.
     */
    public boolean enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: the flag that indicates whether the metric alert is enabled.
     * 
     * @param enabled the enabled value to set.
     * @return the MetricAlertProperties object itself.
     */
    public MetricAlertProperties withEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the scopes property: the list of resource id's that this metric alert is scoped to.
     * 
     * @return the scopes value.
     */
    public List<String> scopes() {
        return this.scopes;
    }

    /**
     * Set the scopes property: the list of resource id's that this metric alert is scoped to.
     * 
     * @param scopes the scopes value to set.
     * @return the MetricAlertProperties object itself.
     */
    public MetricAlertProperties withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    /**
     * Get the evaluationFrequency property: how often the metric alert is evaluated represented in ISO 8601 duration
     * format.
     * 
     * @return the evaluationFrequency value.
     */
    public Duration evaluationFrequency() {
        return this.evaluationFrequency;
    }

    /**
     * Set the evaluationFrequency property: how often the metric alert is evaluated represented in ISO 8601 duration
     * format.
     * 
     * @param evaluationFrequency the evaluationFrequency value to set.
     * @return the MetricAlertProperties object itself.
     */
    public MetricAlertProperties withEvaluationFrequency(Duration evaluationFrequency) {
        this.evaluationFrequency = evaluationFrequency;
        return this;
    }

    /**
     * Get the windowSize property: the period of time (in ISO 8601 duration format) that is used to monitor alert
     * activity based on the threshold.
     * 
     * @return the windowSize value.
     */
    public Duration windowSize() {
        return this.windowSize;
    }

    /**
     * Set the windowSize property: the period of time (in ISO 8601 duration format) that is used to monitor alert
     * activity based on the threshold.
     * 
     * @param windowSize the windowSize value to set.
     * @return the MetricAlertProperties object itself.
     */
    public MetricAlertProperties withWindowSize(Duration windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    /**
     * Get the targetResourceType property: the resource type of the target resource(s) on which the alert is
     * created/updated. Mandatory if the scope contains a subscription, resource group, or more than one resource.
     * 
     * @return the targetResourceType value.
     */
    public String targetResourceType() {
        return this.targetResourceType;
    }

    /**
     * Set the targetResourceType property: the resource type of the target resource(s) on which the alert is
     * created/updated. Mandatory if the scope contains a subscription, resource group, or more than one resource.
     * 
     * @param targetResourceType the targetResourceType value to set.
     * @return the MetricAlertProperties object itself.
     */
    public MetricAlertProperties withTargetResourceType(String targetResourceType) {
        this.targetResourceType = targetResourceType;
        return this;
    }

    /**
     * Get the targetResourceRegion property: the region of the target resource(s) on which the alert is
     * created/updated. Mandatory if the scope contains a subscription, resource group, or more than one resource.
     * 
     * @return the targetResourceRegion value.
     */
    public String targetResourceRegion() {
        return this.targetResourceRegion;
    }

    /**
     * Set the targetResourceRegion property: the region of the target resource(s) on which the alert is
     * created/updated. Mandatory if the scope contains a subscription, resource group, or more than one resource.
     * 
     * @param targetResourceRegion the targetResourceRegion value to set.
     * @return the MetricAlertProperties object itself.
     */
    public MetricAlertProperties withTargetResourceRegion(String targetResourceRegion) {
        this.targetResourceRegion = targetResourceRegion;
        return this;
    }

    /**
     * Get the criteria property: defines the specific alert criteria information.
     * 
     * @return the criteria value.
     */
    public MetricAlertCriteria criteria() {
        return this.criteria;
    }

    /**
     * Set the criteria property: defines the specific alert criteria information.
     * 
     * @param criteria the criteria value to set.
     * @return the MetricAlertProperties object itself.
     */
    public MetricAlertProperties withCriteria(MetricAlertCriteria criteria) {
        this.criteria = criteria;
        return this;
    }

    /**
     * Get the autoMitigate property: the flag that indicates whether the alert should be auto resolved or not. The
     * default is true.
     * 
     * @return the autoMitigate value.
     */
    public Boolean autoMitigate() {
        return this.autoMitigate;
    }

    /**
     * Set the autoMitigate property: the flag that indicates whether the alert should be auto resolved or not. The
     * default is true.
     * 
     * @param autoMitigate the autoMitigate value to set.
     * @return the MetricAlertProperties object itself.
     */
    public MetricAlertProperties withAutoMitigate(Boolean autoMitigate) {
        this.autoMitigate = autoMitigate;
        return this;
    }

    /**
     * Get the actions property: the array of actions that are performed when the alert rule becomes active, and when an
     * alert condition is resolved.
     * 
     * @return the actions value.
     */
    public List<MetricAlertAction> actions() {
        return this.actions;
    }

    /**
     * Set the actions property: the array of actions that are performed when the alert rule becomes active, and when an
     * alert condition is resolved.
     * 
     * @param actions the actions value to set.
     * @return the MetricAlertProperties object itself.
     */
    public MetricAlertProperties withActions(List<MetricAlertAction> actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Get the lastUpdatedTime property: Last time the rule was updated in ISO8601 format.
     * 
     * @return the lastUpdatedTime value.
     */
    public OffsetDateTime lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    /**
     * Get the isMigrated property: the value indicating whether this alert rule is migrated.
     * 
     * @return the isMigrated value.
     */
    public Boolean isMigrated() {
        return this.isMigrated;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (scopes() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property scopes in model MetricAlertProperties"));
        }
        if (evaluationFrequency() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property evaluationFrequency in model MetricAlertProperties"));
        }
        if (windowSize() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property windowSize in model MetricAlertProperties"));
        }
        if (criteria() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property criteria in model MetricAlertProperties"));
        } else {
            criteria().validate();
        }
        if (actions() != null) {
            actions().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MetricAlertProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("severity", this.severity);
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeArrayField("scopes", this.scopes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("evaluationFrequency",
            CoreUtils.durationToStringWithDays(this.evaluationFrequency));
        jsonWriter.writeStringField("windowSize", CoreUtils.durationToStringWithDays(this.windowSize));
        jsonWriter.writeJsonField("criteria", this.criteria);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("targetResourceType", this.targetResourceType);
        jsonWriter.writeStringField("targetResourceRegion", this.targetResourceRegion);
        jsonWriter.writeBooleanField("autoMitigate", this.autoMitigate);
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MetricAlertProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MetricAlertProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MetricAlertProperties.
     */
    public static MetricAlertProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricAlertProperties deserializedMetricAlertProperties = new MetricAlertProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("severity".equals(fieldName)) {
                    deserializedMetricAlertProperties.severity = reader.getInt();
                } else if ("enabled".equals(fieldName)) {
                    deserializedMetricAlertProperties.enabled = reader.getBoolean();
                } else if ("scopes".equals(fieldName)) {
                    List<String> scopes = reader.readArray(reader1 -> reader1.getString());
                    deserializedMetricAlertProperties.scopes = scopes;
                } else if ("evaluationFrequency".equals(fieldName)) {
                    deserializedMetricAlertProperties.evaluationFrequency
                        = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                } else if ("windowSize".equals(fieldName)) {
                    deserializedMetricAlertProperties.windowSize
                        = reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                } else if ("criteria".equals(fieldName)) {
                    deserializedMetricAlertProperties.criteria = MetricAlertCriteria.fromJson(reader);
                } else if ("description".equals(fieldName)) {
                    deserializedMetricAlertProperties.description = reader.getString();
                } else if ("targetResourceType".equals(fieldName)) {
                    deserializedMetricAlertProperties.targetResourceType = reader.getString();
                } else if ("targetResourceRegion".equals(fieldName)) {
                    deserializedMetricAlertProperties.targetResourceRegion = reader.getString();
                } else if ("autoMitigate".equals(fieldName)) {
                    deserializedMetricAlertProperties.autoMitigate = reader.getNullable(JsonReader::getBoolean);
                } else if ("actions".equals(fieldName)) {
                    List<MetricAlertAction> actions = reader.readArray(reader1 -> MetricAlertAction.fromJson(reader1));
                    deserializedMetricAlertProperties.actions = actions;
                } else if ("lastUpdatedTime".equals(fieldName)) {
                    deserializedMetricAlertProperties.lastUpdatedTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("isMigrated".equals(fieldName)) {
                    deserializedMetricAlertProperties.isMigrated = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMetricAlertProperties;
        });
    }
}
