// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents a metric metadata value.
 */
@Fluent
public final class MetadataValueInner implements JsonSerializable<MetadataValueInner> {
    /*
     * the name of the metadata.
     */
    private LocalizableStringInner name;

    /*
     * the value of the metadata.
     */
    private String value;

    /**
     * Creates an instance of MetadataValueInner class.
     */
    public MetadataValueInner() {
    }

    /**
     * Get the name property: the name of the metadata.
     * 
     * @return the name value.
     */
    public LocalizableStringInner name() {
        return this.name;
    }

    /**
     * Set the name property: the name of the metadata.
     * 
     * @param name the name value to set.
     * @return the MetadataValueInner object itself.
     */
    public MetadataValueInner withName(LocalizableStringInner name) {
        this.name = name;
        return this;
    }

    /**
     * Get the value property: the value of the metadata.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: the value of the metadata.
     * 
     * @param value the value value to set.
     * @return the MetadataValueInner object itself.
     */
    public MetadataValueInner withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() != null) {
            name().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("name", this.name);
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MetadataValueInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MetadataValueInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the MetadataValueInner.
     */
    public static MetadataValueInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetadataValueInner deserializedMetadataValueInner = new MetadataValueInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedMetadataValueInner.name = LocalizableStringInner.fromJson(reader);
                } else if ("value".equals(fieldName)) {
                    deserializedMetadataValueInner.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMetadataValueInner;
        });
    }
}
