// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.RetentionPolicy;
import java.io.IOException;
import java.util.List;

/**
 * The log profile properties.
 */
@Fluent
public final class LogProfileProperties implements JsonSerializable<LogProfileProperties> {
    /*
     * the resource id of the storage account to which you would like to send the Activity Log.
     */
    private String storageAccountId;

    /*
     * The service bus rule ID of the service bus namespace in which you would like to have Event Hubs created for
     * streaming the Activity Log. The rule ID is of the format: '{service bus resource ID}/authorizationrules/{key
     * name}'.
     */
    private String serviceBusRuleId;

    /*
     * List of regions for which Activity Log events should be stored or streamed. It is a comma separated list of valid
     * ARM locations including the 'global' location.
     */
    private List<String> locations;

    /*
     * the categories of the logs. These categories are created as is convenient to the user. Some values are: 'Write',
     * 'Delete', and/or 'Action.'
     */
    private List<String> categories;

    /*
     * the retention policy for the events in the log.
     */
    private RetentionPolicy retentionPolicy;

    /**
     * Creates an instance of LogProfileProperties class.
     */
    public LogProfileProperties() {
    }

    /**
     * Get the storageAccountId property: the resource id of the storage account to which you would like to send the
     * Activity Log.
     * 
     * @return the storageAccountId value.
     */
    public String storageAccountId() {
        return this.storageAccountId;
    }

    /**
     * Set the storageAccountId property: the resource id of the storage account to which you would like to send the
     * Activity Log.
     * 
     * @param storageAccountId the storageAccountId value to set.
     * @return the LogProfileProperties object itself.
     */
    public LogProfileProperties withStorageAccountId(String storageAccountId) {
        this.storageAccountId = storageAccountId;
        return this;
    }

    /**
     * Get the serviceBusRuleId property: The service bus rule ID of the service bus namespace in which you would like
     * to have Event Hubs created for streaming the Activity Log. The rule ID is of the format: '{service bus resource
     * ID}/authorizationrules/{key name}'.
     * 
     * @return the serviceBusRuleId value.
     */
    public String serviceBusRuleId() {
        return this.serviceBusRuleId;
    }

    /**
     * Set the serviceBusRuleId property: The service bus rule ID of the service bus namespace in which you would like
     * to have Event Hubs created for streaming the Activity Log. The rule ID is of the format: '{service bus resource
     * ID}/authorizationrules/{key name}'.
     * 
     * @param serviceBusRuleId the serviceBusRuleId value to set.
     * @return the LogProfileProperties object itself.
     */
    public LogProfileProperties withServiceBusRuleId(String serviceBusRuleId) {
        this.serviceBusRuleId = serviceBusRuleId;
        return this;
    }

    /**
     * Get the locations property: List of regions for which Activity Log events should be stored or streamed. It is a
     * comma separated list of valid ARM locations including the 'global' location.
     * 
     * @return the locations value.
     */
    public List<String> locations() {
        return this.locations;
    }

    /**
     * Set the locations property: List of regions for which Activity Log events should be stored or streamed. It is a
     * comma separated list of valid ARM locations including the 'global' location.
     * 
     * @param locations the locations value to set.
     * @return the LogProfileProperties object itself.
     */
    public LogProfileProperties withLocations(List<String> locations) {
        this.locations = locations;
        return this;
    }

    /**
     * Get the categories property: the categories of the logs. These categories are created as is convenient to the
     * user. Some values are: 'Write', 'Delete', and/or 'Action.'.
     * 
     * @return the categories value.
     */
    public List<String> categories() {
        return this.categories;
    }

    /**
     * Set the categories property: the categories of the logs. These categories are created as is convenient to the
     * user. Some values are: 'Write', 'Delete', and/or 'Action.'.
     * 
     * @param categories the categories value to set.
     * @return the LogProfileProperties object itself.
     */
    public LogProfileProperties withCategories(List<String> categories) {
        this.categories = categories;
        return this;
    }

    /**
     * Get the retentionPolicy property: the retention policy for the events in the log.
     * 
     * @return the retentionPolicy value.
     */
    public RetentionPolicy retentionPolicy() {
        return this.retentionPolicy;
    }

    /**
     * Set the retentionPolicy property: the retention policy for the events in the log.
     * 
     * @param retentionPolicy the retentionPolicy value to set.
     * @return the LogProfileProperties object itself.
     */
    public LogProfileProperties withRetentionPolicy(RetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (locations() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property locations in model LogProfileProperties"));
        }
        if (categories() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property categories in model LogProfileProperties"));
        }
        if (retentionPolicy() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property retentionPolicy in model LogProfileProperties"));
        } else {
            retentionPolicy().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LogProfileProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("locations", this.locations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("categories", this.categories, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("retentionPolicy", this.retentionPolicy);
        jsonWriter.writeStringField("storageAccountId", this.storageAccountId);
        jsonWriter.writeStringField("serviceBusRuleId", this.serviceBusRuleId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LogProfileProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LogProfileProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LogProfileProperties.
     */
    public static LogProfileProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LogProfileProperties deserializedLogProfileProperties = new LogProfileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("locations".equals(fieldName)) {
                    List<String> locations = reader.readArray(reader1 -> reader1.getString());
                    deserializedLogProfileProperties.locations = locations;
                } else if ("categories".equals(fieldName)) {
                    List<String> categories = reader.readArray(reader1 -> reader1.getString());
                    deserializedLogProfileProperties.categories = categories;
                } else if ("retentionPolicy".equals(fieldName)) {
                    deserializedLogProfileProperties.retentionPolicy = RetentionPolicy.fromJson(reader);
                } else if ("storageAccountId".equals(fieldName)) {
                    deserializedLogProfileProperties.storageAccountId = reader.getString();
                } else if ("serviceBusRuleId".equals(fieldName)) {
                    deserializedLogProfileProperties.serviceBusRuleId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLogProfileProperties;
        });
    }
}
