// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The localizable string class.
 */
@Fluent
public final class LocalizableStringInner implements JsonSerializable<LocalizableStringInner> {
    /*
     * the invariant value.
     */
    private String value;

    /*
     * the locale specific value.
     */
    private String localizedValue;

    /**
     * Creates an instance of LocalizableStringInner class.
     */
    public LocalizableStringInner() {
    }

    /**
     * Get the value property: the invariant value.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: the invariant value.
     * 
     * @param value the value value to set.
     * @return the LocalizableStringInner object itself.
     */
    public LocalizableStringInner withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Get the localizedValue property: the locale specific value.
     * 
     * @return the localizedValue value.
     */
    public String localizedValue() {
        return this.localizedValue;
    }

    /**
     * Set the localizedValue property: the locale specific value.
     * 
     * @param localizedValue the localizedValue value to set.
     * @return the LocalizableStringInner object itself.
     */
    public LocalizableStringInner withLocalizedValue(String localizedValue) {
        this.localizedValue = localizedValue;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model LocalizableStringInner"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LocalizableStringInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.value);
        jsonWriter.writeStringField("localizedValue", this.localizedValue);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LocalizableStringInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LocalizableStringInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LocalizableStringInner.
     */
    public static LocalizableStringInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LocalizableStringInner deserializedLocalizableStringInner = new LocalizableStringInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    deserializedLocalizableStringInner.value = reader.getString();
                } else if ("localizedValue".equals(fieldName)) {
                    deserializedLocalizableStringInner.localizedValue = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLocalizableStringInner;
        });
    }
}
