// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.AutoscaleNotification;
import com.azure.resourcemanager.monitor.models.PredictiveAutoscalePolicy;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * The autoscale setting resource.
 */
@Fluent
public final class AutoscaleSettingResourceInner extends Resource {
    /*
     * The autoscale setting of the resource.
     */
    private AutoscaleSetting innerProperties = new AutoscaleSetting();

    /*
     * The system metadata related to the response.
     */
    private SystemData systemData;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of AutoscaleSettingResourceInner class.
     */
    public AutoscaleSettingResourceInner() {
    }

    /**
     * Get the innerProperties property: The autoscale setting of the resource.
     * 
     * @return the innerProperties value.
     */
    private AutoscaleSetting innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system metadata related to the response.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AutoscaleSettingResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AutoscaleSettingResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the profiles property: the collection of automatic scaling profiles that specify different scaling parameters
     * for different time periods. A maximum of 20 profiles can be specified.
     * 
     * @return the profiles value.
     */
    public List<AutoscaleProfileInner> profiles() {
        return this.innerProperties() == null ? null : this.innerProperties().profiles();
    }

    /**
     * Set the profiles property: the collection of automatic scaling profiles that specify different scaling parameters
     * for different time periods. A maximum of 20 profiles can be specified.
     * 
     * @param profiles the profiles value to set.
     * @return the AutoscaleSettingResourceInner object itself.
     */
    public AutoscaleSettingResourceInner withProfiles(List<AutoscaleProfileInner> profiles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoscaleSetting();
        }
        this.innerProperties().withProfiles(profiles);
        return this;
    }

    /**
     * Get the notifications property: the collection of notifications.
     * 
     * @return the notifications value.
     */
    public List<AutoscaleNotification> notifications() {
        return this.innerProperties() == null ? null : this.innerProperties().notifications();
    }

    /**
     * Set the notifications property: the collection of notifications.
     * 
     * @param notifications the notifications value to set.
     * @return the AutoscaleSettingResourceInner object itself.
     */
    public AutoscaleSettingResourceInner withNotifications(List<AutoscaleNotification> notifications) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoscaleSetting();
        }
        this.innerProperties().withNotifications(notifications);
        return this;
    }

    /**
     * Get the enabled property: the enabled flag. Specifies whether automatic scaling is enabled for the resource. The
     * default value is 'false'.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    /**
     * Set the enabled property: the enabled flag. Specifies whether automatic scaling is enabled for the resource. The
     * default value is 'false'.
     * 
     * @param enabled the enabled value to set.
     * @return the AutoscaleSettingResourceInner object itself.
     */
    public AutoscaleSettingResourceInner withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoscaleSetting();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    /**
     * Get the predictiveAutoscalePolicy property: the predictive autoscale policy mode.
     * 
     * @return the predictiveAutoscalePolicy value.
     */
    public PredictiveAutoscalePolicy predictiveAutoscalePolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().predictiveAutoscalePolicy();
    }

    /**
     * Set the predictiveAutoscalePolicy property: the predictive autoscale policy mode.
     * 
     * @param predictiveAutoscalePolicy the predictiveAutoscalePolicy value to set.
     * @return the AutoscaleSettingResourceInner object itself.
     */
    public AutoscaleSettingResourceInner
        withPredictiveAutoscalePolicy(PredictiveAutoscalePolicy predictiveAutoscalePolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoscaleSetting();
        }
        this.innerProperties().withPredictiveAutoscalePolicy(predictiveAutoscalePolicy);
        return this;
    }

    /**
     * Get the name property: the name of the autoscale setting.
     * 
     * @return the name value.
     */
    public String namePropertiesName() {
        return this.innerProperties() == null ? null : this.innerProperties().name();
    }

    /**
     * Set the name property: the name of the autoscale setting.
     * 
     * @param name the name value to set.
     * @return the AutoscaleSettingResourceInner object itself.
     */
    public AutoscaleSettingResourceInner withNamePropertiesName(String name) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoscaleSetting();
        }
        this.innerProperties().withName(name);
        return this;
    }

    /**
     * Get the targetResourceUri property: the resource identifier of the resource that the autoscale setting should be
     * added to.
     * 
     * @return the targetResourceUri value.
     */
    public String targetResourceUri() {
        return this.innerProperties() == null ? null : this.innerProperties().targetResourceUri();
    }

    /**
     * Set the targetResourceUri property: the resource identifier of the resource that the autoscale setting should be
     * added to.
     * 
     * @param targetResourceUri the targetResourceUri value to set.
     * @return the AutoscaleSettingResourceInner object itself.
     */
    public AutoscaleSettingResourceInner withTargetResourceUri(String targetResourceUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoscaleSetting();
        }
        this.innerProperties().withTargetResourceUri(targetResourceUri);
        return this;
    }

    /**
     * Get the targetResourceLocation property: the location of the resource that the autoscale setting should be added
     * to.
     * 
     * @return the targetResourceLocation value.
     */
    public String targetResourceLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().targetResourceLocation();
    }

    /**
     * Set the targetResourceLocation property: the location of the resource that the autoscale setting should be added
     * to.
     * 
     * @param targetResourceLocation the targetResourceLocation value to set.
     * @return the AutoscaleSettingResourceInner object itself.
     */
    public AutoscaleSettingResourceInner withTargetResourceLocation(String targetResourceLocation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AutoscaleSetting();
        }
        this.innerProperties().withTargetResourceLocation(targetResourceLocation);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property innerProperties in model AutoscaleSettingResourceInner"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AutoscaleSettingResourceInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AutoscaleSettingResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AutoscaleSettingResourceInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AutoscaleSettingResourceInner.
     */
    public static AutoscaleSettingResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AutoscaleSettingResourceInner deserializedAutoscaleSettingResourceInner
                = new AutoscaleSettingResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAutoscaleSettingResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedAutoscaleSettingResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedAutoscaleSettingResourceInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedAutoscaleSettingResourceInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAutoscaleSettingResourceInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedAutoscaleSettingResourceInner.innerProperties = AutoscaleSetting.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedAutoscaleSettingResourceInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAutoscaleSettingResourceInner;
        });
    }
}
