// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.RuleAction;
import com.azure.resourcemanager.monitor.models.RuleCondition;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * An alert rule.
 */
@Fluent
public final class AlertRule implements JsonSerializable<AlertRule> {
    /*
     * the name of the alert rule.
     */
    private String name;

    /*
     * the description of the alert rule that will be included in the alert email.
     */
    private String description;

    /*
     * the provisioning state.
     */
    private String provisioningState;

    /*
     * the flag that indicates whether the alert rule is enabled.
     */
    private boolean isEnabled;

    /*
     * the condition that results in the alert rule being activated.
     */
    private RuleCondition condition;

    /*
     * action that is performed when the alert rule becomes active, and when an alert condition is resolved.
     */
    private RuleAction action;

    /*
     * the array of actions that are performed when the alert rule becomes active, and when an alert condition is
     * resolved.
     */
    private List<RuleAction> actions;

    /*
     * Last time the rule was updated in ISO8601 format.
     */
    private OffsetDateTime lastUpdatedTime;

    /**
     * Creates an instance of AlertRule class.
     */
    public AlertRule() {
    }

    /**
     * Get the name property: the name of the alert rule.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: the name of the alert rule.
     * 
     * @param name the name value to set.
     * @return the AlertRule object itself.
     */
    public AlertRule withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the description property: the description of the alert rule that will be included in the alert email.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: the description of the alert rule that will be included in the alert email.
     * 
     * @param description the description value to set.
     * @return the AlertRule object itself.
     */
    public AlertRule withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the provisioningState property: the provisioning state.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState property: the provisioning state.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the AlertRule object itself.
     */
    public AlertRule withProvisioningState(String provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Get the isEnabled property: the flag that indicates whether the alert rule is enabled.
     * 
     * @return the isEnabled value.
     */
    public boolean isEnabled() {
        return this.isEnabled;
    }

    /**
     * Set the isEnabled property: the flag that indicates whether the alert rule is enabled.
     * 
     * @param isEnabled the isEnabled value to set.
     * @return the AlertRule object itself.
     */
    public AlertRule withIsEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    /**
     * Get the condition property: the condition that results in the alert rule being activated.
     * 
     * @return the condition value.
     */
    public RuleCondition condition() {
        return this.condition;
    }

    /**
     * Set the condition property: the condition that results in the alert rule being activated.
     * 
     * @param condition the condition value to set.
     * @return the AlertRule object itself.
     */
    public AlertRule withCondition(RuleCondition condition) {
        this.condition = condition;
        return this;
    }

    /**
     * Get the action property: action that is performed when the alert rule becomes active, and when an alert condition
     * is resolved.
     * 
     * @return the action value.
     */
    public RuleAction action() {
        return this.action;
    }

    /**
     * Set the action property: action that is performed when the alert rule becomes active, and when an alert condition
     * is resolved.
     * 
     * @param action the action value to set.
     * @return the AlertRule object itself.
     */
    public AlertRule withAction(RuleAction action) {
        this.action = action;
        return this;
    }

    /**
     * Get the actions property: the array of actions that are performed when the alert rule becomes active, and when an
     * alert condition is resolved.
     * 
     * @return the actions value.
     */
    public List<RuleAction> actions() {
        return this.actions;
    }

    /**
     * Set the actions property: the array of actions that are performed when the alert rule becomes active, and when an
     * alert condition is resolved.
     * 
     * @param actions the actions value to set.
     * @return the AlertRule object itself.
     */
    public AlertRule withActions(List<RuleAction> actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Get the lastUpdatedTime property: Last time the rule was updated in ISO8601 format.
     * 
     * @return the lastUpdatedTime value.
     */
    public OffsetDateTime lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model AlertRule"));
        }
        if (condition() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property condition in model AlertRule"));
        } else {
            condition().validate();
        }
        if (action() != null) {
            action().validate();
        }
        if (actions() != null) {
            actions().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AlertRule.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeBooleanField("isEnabled", this.isEnabled);
        jsonWriter.writeJsonField("condition", this.condition);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("provisioningState", this.provisioningState);
        jsonWriter.writeJsonField("action", this.action);
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AlertRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AlertRule if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AlertRule.
     */
    public static AlertRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AlertRule deserializedAlertRule = new AlertRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedAlertRule.name = reader.getString();
                } else if ("isEnabled".equals(fieldName)) {
                    deserializedAlertRule.isEnabled = reader.getBoolean();
                } else if ("condition".equals(fieldName)) {
                    deserializedAlertRule.condition = RuleCondition.fromJson(reader);
                } else if ("description".equals(fieldName)) {
                    deserializedAlertRule.description = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedAlertRule.provisioningState = reader.getString();
                } else if ("action".equals(fieldName)) {
                    deserializedAlertRule.action = RuleAction.fromJson(reader);
                } else if ("actions".equals(fieldName)) {
                    List<RuleAction> actions = reader.readArray(reader1 -> RuleAction.fromJson(reader1));
                    deserializedAlertRule.actions = actions;
                } else if ("lastUpdatedTime".equals(fieldName)) {
                    deserializedAlertRule.lastUpdatedTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAlertRule;
        });
    }
}
