/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.PredictiveAutoscalePolicyScaleMode;
import java.io.IOException;
import java.time.Duration;

public final class PredictiveAutoscalePolicy
implements JsonSerializable<PredictiveAutoscalePolicy> {
    private PredictiveAutoscalePolicyScaleMode scaleMode;
    private Duration scaleLookAheadTime;
    private static final ClientLogger LOGGER = new ClientLogger(PredictiveAutoscalePolicy.class);

    public PredictiveAutoscalePolicyScaleMode scaleMode() {
        return this.scaleMode;
    }

    public PredictiveAutoscalePolicy withScaleMode(PredictiveAutoscalePolicyScaleMode scaleMode) {
        this.scaleMode = scaleMode;
        return this;
    }

    public Duration scaleLookAheadTime() {
        return this.scaleLookAheadTime;
    }

    public PredictiveAutoscalePolicy withScaleLookAheadTime(Duration scaleLookAheadTime) {
        this.scaleLookAheadTime = scaleLookAheadTime;
        return this;
    }

    public void validate() {
        if (this.scaleMode() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property scaleMode in model PredictiveAutoscalePolicy"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scaleMode", this.scaleMode == null ? null : this.scaleMode.toString());
        jsonWriter.writeStringField("scaleLookAheadTime", CoreUtils.durationToStringWithDays((Duration)this.scaleLookAheadTime));
        return jsonWriter.writeEndObject();
    }

    public static PredictiveAutoscalePolicy fromJson(JsonReader jsonReader) throws IOException {
        return (PredictiveAutoscalePolicy)jsonReader.readObject(reader -> {
            PredictiveAutoscalePolicy deserializedPredictiveAutoscalePolicy = new PredictiveAutoscalePolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("scaleMode".equals(fieldName)) {
                    deserializedPredictiveAutoscalePolicy.scaleMode = PredictiveAutoscalePolicyScaleMode.fromString(reader.getString());
                    continue;
                }
                if ("scaleLookAheadTime".equals(fieldName)) {
                    deserializedPredictiveAutoscalePolicy.scaleLookAheadTime = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPredictiveAutoscalePolicy;
        });
    }
}

