// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Resource properties.
 */
@Fluent
public final class WorkspaceInfoProperties implements JsonSerializable<WorkspaceInfoProperties> {
    /*
     * Log Analytics workspace identifier.
     */
    private String customerId;

    /**
     * Creates an instance of WorkspaceInfoProperties class.
     */
    public WorkspaceInfoProperties() {
    }

    /**
     * Get the customerId property: Log Analytics workspace identifier.
     * 
     * @return the customerId value.
     */
    public String customerId() {
        return this.customerId;
    }

    /**
     * Set the customerId property: Log Analytics workspace identifier.
     * 
     * @param customerId the customerId value to set.
     * @return the WorkspaceInfoProperties object itself.
     */
    public WorkspaceInfoProperties withCustomerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (customerId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property customerId in model WorkspaceInfoProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceInfoProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("customerId", this.customerId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkspaceInfoProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkspaceInfoProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the WorkspaceInfoProperties.
     */
    public static WorkspaceInfoProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkspaceInfoProperties deserializedWorkspaceInfoProperties = new WorkspaceInfoProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("customerId".equals(fieldName)) {
                    deserializedWorkspaceInfoProperties.customerId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkspaceInfoProperties;
        });
    }
}
