/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.BaselineMetadata;
import com.azure.resourcemanager.monitor.models.MetricSingleDimension;
import com.azure.resourcemanager.monitor.models.SingleBaseline;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.List;

public final class TimeSeriesBaseline
implements JsonSerializable<TimeSeriesBaseline> {
    private String aggregation;
    private List<MetricSingleDimension> dimensions;
    private List<OffsetDateTime> timestamps;
    private List<SingleBaseline> data;
    private List<BaselineMetadata> metadataValues;
    private static final ClientLogger LOGGER = new ClientLogger(TimeSeriesBaseline.class);

    public String aggregation() {
        return this.aggregation;
    }

    public TimeSeriesBaseline withAggregation(String aggregation) {
        this.aggregation = aggregation;
        return this;
    }

    public List<MetricSingleDimension> dimensions() {
        return this.dimensions;
    }

    public TimeSeriesBaseline withDimensions(List<MetricSingleDimension> dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public List<OffsetDateTime> timestamps() {
        return this.timestamps;
    }

    public TimeSeriesBaseline withTimestamps(List<OffsetDateTime> timestamps) {
        this.timestamps = timestamps;
        return this;
    }

    public List<SingleBaseline> data() {
        return this.data;
    }

    public TimeSeriesBaseline withData(List<SingleBaseline> data) {
        this.data = data;
        return this;
    }

    public List<BaselineMetadata> metadataValues() {
        return this.metadataValues;
    }

    public TimeSeriesBaseline withMetadataValues(List<BaselineMetadata> metadataValues) {
        this.metadataValues = metadataValues;
        return this;
    }

    public void validate() {
        if (this.aggregation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property aggregation in model TimeSeriesBaseline"));
        }
        if (this.dimensions() != null) {
            this.dimensions().forEach(e -> e.validate());
        }
        if (this.timestamps() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property timestamps in model TimeSeriesBaseline"));
        }
        if (this.data() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property data in model TimeSeriesBaseline"));
        }
        this.data().forEach(e -> e.validate());
        if (this.metadataValues() != null) {
            this.metadataValues().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("aggregation", this.aggregation);
        jsonWriter.writeArrayField("timestamps", this.timestamps, (writer, element) -> writer.writeString(element == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format((TemporalAccessor)element)));
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("dimensions", this.dimensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("metadataValues", this.metadataValues, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TimeSeriesBaseline fromJson(JsonReader jsonReader) throws IOException {
        return (TimeSeriesBaseline)jsonReader.readObject(reader -> {
            TimeSeriesBaseline deserializedTimeSeriesBaseline = new TimeSeriesBaseline();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("aggregation".equals(fieldName)) {
                    deserializedTimeSeriesBaseline.aggregation = reader.getString();
                    continue;
                }
                if ("timestamps".equals(fieldName)) {
                    List timestamps;
                    deserializedTimeSeriesBaseline.timestamps = timestamps = reader.readArray(reader1 -> (OffsetDateTime)reader1.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("data".equals(fieldName)) {
                    List data;
                    deserializedTimeSeriesBaseline.data = data = reader.readArray(reader1 -> SingleBaseline.fromJson(reader1));
                    continue;
                }
                if ("dimensions".equals(fieldName)) {
                    List dimensions;
                    deserializedTimeSeriesBaseline.dimensions = dimensions = reader.readArray(reader1 -> MetricSingleDimension.fromJson(reader1));
                    continue;
                }
                if ("metadataValues".equals(fieldName)) {
                    List metadataValues;
                    deserializedTimeSeriesBaseline.metadataValues = metadataValues = reader.readArray(reader1 -> BaselineMetadata.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTimeSeriesBaseline;
        });
    }
}

