// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.SingleMetricBaselineInner;
import java.io.IOException;
import java.util.List;

/**
 * A list of metric baselines.
 */
@Fluent
public final class MetricBaselinesResponse implements JsonSerializable<MetricBaselinesResponse> {
    /*
     * The list of metric baselines.
     */
    private List<SingleMetricBaselineInner> value;

    /**
     * Creates an instance of MetricBaselinesResponse class.
     */
    public MetricBaselinesResponse() {
    }

    /**
     * Get the value property: The list of metric baselines.
     * 
     * @return the value value.
     */
    public List<SingleMetricBaselineInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of metric baselines.
     * 
     * @param value the value value to set.
     * @return the MetricBaselinesResponse object itself.
     */
    public MetricBaselinesResponse withValue(List<SingleMetricBaselineInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MetricBaselinesResponse from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MetricBaselinesResponse if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MetricBaselinesResponse.
     */
    public static MetricBaselinesResponse fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricBaselinesResponse deserializedMetricBaselinesResponse = new MetricBaselinesResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<SingleMetricBaselineInner> value
                        = reader.readArray(reader1 -> SingleMetricBaselineInner.fromJson(reader1));
                    deserializedMetricBaselinesResponse.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMetricBaselinesResponse;
        });
    }
}
