// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Text settings.
 */
@Fluent
public final class LogFileSettingsText extends LogFileTextSettings {
    /**
     * Creates an instance of LogFileSettingsText class.
     */
    public LogFileSettingsText() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public LogFileSettingsText
        withRecordStartTimestampFormat(KnownLogFileTextSettingsRecordStartTimestampFormat recordStartTimestampFormat) {
        super.withRecordStartTimestampFormat(recordStartTimestampFormat);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recordStartTimestampFormat",
            recordStartTimestampFormat() == null ? null : recordStartTimestampFormat().toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LogFileSettingsText from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LogFileSettingsText if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LogFileSettingsText.
     */
    public static LogFileSettingsText fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LogFileSettingsText deserializedLogFileSettingsText = new LogFileSettingsText();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("recordStartTimestampFormat".equals(fieldName)) {
                    deserializedLogFileSettingsText.withRecordStartTimestampFormat(
                        KnownLogFileTextSettingsRecordStartTimestampFormat.fromString(reader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLogFileSettingsText;
        });
    }
}
