// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.AlertRuleResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * Represents a collection of alert rule resources.
 */
@Fluent
public final class AlertRuleResourceCollection implements JsonSerializable<AlertRuleResourceCollection> {
    /*
     * the values for the alert rule resources.
     */
    private List<AlertRuleResourceInner> value;

    /**
     * Creates an instance of AlertRuleResourceCollection class.
     */
    public AlertRuleResourceCollection() {
    }

    /**
     * Get the value property: the values for the alert rule resources.
     * 
     * @return the value value.
     */
    public List<AlertRuleResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: the values for the alert rule resources.
     * 
     * @param value the value value to set.
     * @return the AlertRuleResourceCollection object itself.
     */
    public AlertRuleResourceCollection withValue(List<AlertRuleResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AlertRuleResourceCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AlertRuleResourceCollection if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AlertRuleResourceCollection.
     */
    public static AlertRuleResourceCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AlertRuleResourceCollection deserializedAlertRuleResourceCollection = new AlertRuleResourceCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<AlertRuleResourceInner> value
                        = reader.readArray(reader1 -> AlertRuleResourceInner.fromJson(reader1));
                    deserializedAlertRuleResourceCollection.value = value;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAlertRuleResourceCollection;
        });
    }
}
