/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.LocalizableStringInner;
import com.azure.resourcemanager.monitor.models.TimeSeriesElement;
import com.azure.resourcemanager.monitor.models.Unit;
import java.io.IOException;
import java.util.List;

public final class MetricInner
implements JsonSerializable<MetricInner> {
    private String id;
    private String type;
    private LocalizableStringInner name;
    private String displayDescription;
    private String errorCode;
    private String errorMessage;
    private Unit unit;
    private List<TimeSeriesElement> timeseries;
    private static final ClientLogger LOGGER = new ClientLogger(MetricInner.class);

    public String id() {
        return this.id;
    }

    public MetricInner withId(String id) {
        this.id = id;
        return this;
    }

    public String type() {
        return this.type;
    }

    public MetricInner withType(String type) {
        this.type = type;
        return this;
    }

    public LocalizableStringInner name() {
        return this.name;
    }

    public MetricInner withName(LocalizableStringInner name) {
        this.name = name;
        return this;
    }

    public String displayDescription() {
        return this.displayDescription;
    }

    public MetricInner withDisplayDescription(String displayDescription) {
        this.displayDescription = displayDescription;
        return this;
    }

    public String errorCode() {
        return this.errorCode;
    }

    public MetricInner withErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public MetricInner withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public Unit unit() {
        return this.unit;
    }

    public MetricInner withUnit(Unit unit) {
        this.unit = unit;
        return this;
    }

    public List<TimeSeriesElement> timeseries() {
        return this.timeseries;
    }

    public MetricInner withTimeseries(List<TimeSeriesElement> timeseries) {
        this.timeseries = timeseries;
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model MetricInner"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model MetricInner"));
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model MetricInner"));
        }
        this.name().validate();
        if (this.unit() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property unit in model MetricInner"));
        }
        if (this.timeseries() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property timeseries in model MetricInner"));
        }
        this.timeseries().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("name", (JsonSerializable)this.name);
        jsonWriter.writeStringField("unit", this.unit == null ? null : this.unit.toString());
        jsonWriter.writeArrayField("timeseries", this.timeseries, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("displayDescription", this.displayDescription);
        jsonWriter.writeStringField("errorCode", this.errorCode);
        jsonWriter.writeStringField("errorMessage", this.errorMessage);
        return jsonWriter.writeEndObject();
    }

    public static MetricInner fromJson(JsonReader jsonReader) throws IOException {
        return (MetricInner)jsonReader.readObject(reader -> {
            MetricInner deserializedMetricInner = new MetricInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMetricInner.id = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMetricInner.type = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMetricInner.name = LocalizableStringInner.fromJson(reader);
                    continue;
                }
                if ("unit".equals(fieldName)) {
                    deserializedMetricInner.unit = Unit.fromString(reader.getString());
                    continue;
                }
                if ("timeseries".equals(fieldName)) {
                    List timeseries;
                    deserializedMetricInner.timeseries = timeseries = reader.readArray(reader1 -> TimeSeriesElement.fromJson(reader1));
                    continue;
                }
                if ("displayDescription".equals(fieldName)) {
                    deserializedMetricInner.displayDescription = reader.getString();
                    continue;
                }
                if ("errorCode".equals(fieldName)) {
                    deserializedMetricInner.errorCode = reader.getString();
                    continue;
                }
                if ("errorMessage".equals(fieldName)) {
                    deserializedMetricInner.errorMessage = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricInner;
        });
    }
}

