// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Email notification of an autoscale event.
 */
@Fluent
public final class EmailNotification implements JsonSerializable<EmailNotification> {
    /*
     * a value indicating whether to send email to subscription administrator.
     */
    private Boolean sendToSubscriptionAdministrator;

    /*
     * a value indicating whether to send email to subscription co-administrators.
     */
    private Boolean sendToSubscriptionCoAdministrators;

    /*
     * the custom e-mails list. This value can be null or empty, in which case this attribute will be ignored.
     */
    private List<String> customEmails;

    /**
     * Creates an instance of EmailNotification class.
     */
    public EmailNotification() {
    }

    /**
     * Get the sendToSubscriptionAdministrator property: a value indicating whether to send email to subscription
     * administrator.
     * 
     * @return the sendToSubscriptionAdministrator value.
     */
    public Boolean sendToSubscriptionAdministrator() {
        return this.sendToSubscriptionAdministrator;
    }

    /**
     * Set the sendToSubscriptionAdministrator property: a value indicating whether to send email to subscription
     * administrator.
     * 
     * @param sendToSubscriptionAdministrator the sendToSubscriptionAdministrator value to set.
     * @return the EmailNotification object itself.
     */
    public EmailNotification withSendToSubscriptionAdministrator(Boolean sendToSubscriptionAdministrator) {
        this.sendToSubscriptionAdministrator = sendToSubscriptionAdministrator;
        return this;
    }

    /**
     * Get the sendToSubscriptionCoAdministrators property: a value indicating whether to send email to subscription
     * co-administrators.
     * 
     * @return the sendToSubscriptionCoAdministrators value.
     */
    public Boolean sendToSubscriptionCoAdministrators() {
        return this.sendToSubscriptionCoAdministrators;
    }

    /**
     * Set the sendToSubscriptionCoAdministrators property: a value indicating whether to send email to subscription
     * co-administrators.
     * 
     * @param sendToSubscriptionCoAdministrators the sendToSubscriptionCoAdministrators value to set.
     * @return the EmailNotification object itself.
     */
    public EmailNotification withSendToSubscriptionCoAdministrators(Boolean sendToSubscriptionCoAdministrators) {
        this.sendToSubscriptionCoAdministrators = sendToSubscriptionCoAdministrators;
        return this;
    }

    /**
     * Get the customEmails property: the custom e-mails list. This value can be null or empty, in which case this
     * attribute will be ignored.
     * 
     * @return the customEmails value.
     */
    public List<String> customEmails() {
        return this.customEmails;
    }

    /**
     * Set the customEmails property: the custom e-mails list. This value can be null or empty, in which case this
     * attribute will be ignored.
     * 
     * @param customEmails the customEmails value to set.
     * @return the EmailNotification object itself.
     */
    public EmailNotification withCustomEmails(List<String> customEmails) {
        this.customEmails = customEmails;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("sendToSubscriptionAdministrator", this.sendToSubscriptionAdministrator);
        jsonWriter.writeBooleanField("sendToSubscriptionCoAdministrators", this.sendToSubscriptionCoAdministrators);
        jsonWriter.writeArrayField("customEmails", this.customEmails, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EmailNotification from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EmailNotification if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the EmailNotification.
     */
    public static EmailNotification fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EmailNotification deserializedEmailNotification = new EmailNotification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sendToSubscriptionAdministrator".equals(fieldName)) {
                    deserializedEmailNotification.sendToSubscriptionAdministrator
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("sendToSubscriptionCoAdministrators".equals(fieldName)) {
                    deserializedEmailNotification.sendToSubscriptionCoAdministrators
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("customEmails".equals(fieldName)) {
                    List<String> customEmails = reader.readArray(reader1 -> reader1.getString());
                    deserializedEmailNotification.customEmails = customEmails;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEmailNotification;
        });
    }
}
