/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class MetricDimension
implements JsonSerializable<MetricDimension> {
    private String name;
    private String operator;
    private List<String> values;
    private static final ClientLogger LOGGER = new ClientLogger(MetricDimension.class);

    public String name() {
        return this.name;
    }

    public MetricDimension withName(String name) {
        this.name = name;
        return this;
    }

    public String operator() {
        return this.operator;
    }

    public MetricDimension withOperator(String operator) {
        this.operator = operator;
        return this;
    }

    public List<String> values() {
        return this.values;
    }

    public MetricDimension withValues(List<String> values) {
        this.values = values;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model MetricDimension"));
        }
        if (this.operator() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operator in model MetricDimension"));
        }
        if (this.values() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property values in model MetricDimension"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("operator", this.operator);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static MetricDimension fromJson(JsonReader jsonReader) throws IOException {
        return (MetricDimension)jsonReader.readObject(reader -> {
            MetricDimension deserializedMetricDimension = new MetricDimension();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedMetricDimension.name = reader.getString();
                    continue;
                }
                if ("operator".equals(fieldName)) {
                    deserializedMetricDimension.operator = reader.getString();
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedMetricDimension.values = values = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMetricDimension;
        });
    }
}

