/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.AccessMode;
import java.io.IOException;

public final class AccessModeSettingsExclusion
implements JsonSerializable<AccessModeSettingsExclusion> {
    private String privateEndpointConnectionName;
    private AccessMode queryAccessMode;
    private AccessMode ingestionAccessMode;

    public String privateEndpointConnectionName() {
        return this.privateEndpointConnectionName;
    }

    public AccessModeSettingsExclusion withPrivateEndpointConnectionName(String privateEndpointConnectionName) {
        this.privateEndpointConnectionName = privateEndpointConnectionName;
        return this;
    }

    public AccessMode queryAccessMode() {
        return this.queryAccessMode;
    }

    public AccessModeSettingsExclusion withQueryAccessMode(AccessMode queryAccessMode) {
        this.queryAccessMode = queryAccessMode;
        return this;
    }

    public AccessMode ingestionAccessMode() {
        return this.ingestionAccessMode;
    }

    public AccessModeSettingsExclusion withIngestionAccessMode(AccessMode ingestionAccessMode) {
        this.ingestionAccessMode = ingestionAccessMode;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("privateEndpointConnectionName", this.privateEndpointConnectionName);
        jsonWriter.writeStringField("queryAccessMode", this.queryAccessMode == null ? null : this.queryAccessMode.toString());
        jsonWriter.writeStringField("ingestionAccessMode", this.ingestionAccessMode == null ? null : this.ingestionAccessMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static AccessModeSettingsExclusion fromJson(JsonReader jsonReader) throws IOException {
        return (AccessModeSettingsExclusion)jsonReader.readObject(reader -> {
            AccessModeSettingsExclusion deserializedAccessModeSettingsExclusion = new AccessModeSettingsExclusion();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privateEndpointConnectionName".equals(fieldName)) {
                    deserializedAccessModeSettingsExclusion.privateEndpointConnectionName = reader.getString();
                    continue;
                }
                if ("queryAccessMode".equals(fieldName)) {
                    deserializedAccessModeSettingsExclusion.queryAccessMode = AccessMode.fromString(reader.getString());
                    continue;
                }
                if ("ingestionAccessMode".equals(fieldName)) {
                    deserializedAccessModeSettingsExclusion.ingestionAccessMode = AccessMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAccessModeSettingsExclusion;
        });
    }
}

