/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class PredictiveValue
implements JsonSerializable<PredictiveValue> {
    private OffsetDateTime timestamp;
    private double value;
    private static final ClientLogger LOGGER = new ClientLogger(PredictiveValue.class);

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public PredictiveValue withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public double value() {
        return this.value;
    }

    public PredictiveValue withValue(double value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.timestamp() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property timestamp in model PredictiveValue"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timeStamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeDoubleField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    public static PredictiveValue fromJson(JsonReader jsonReader) throws IOException {
        return (PredictiveValue)jsonReader.readObject(reader -> {
            PredictiveValue deserializedPredictiveValue = new PredictiveValue();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timeStamp".equals(fieldName)) {
                    deserializedPredictiveValue.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedPredictiveValue.value = reader.getDouble();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPredictiveValue;
        });
    }
}

