// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Definition of which Windows Event Log events will be collected and how they will be collected.
 * Only collected from Windows machines.
 */
@Fluent
public final class WindowsEventLogDataSource implements JsonSerializable<WindowsEventLogDataSource> {
    /*
     * List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will
     * be sent to.
     */
    private List<KnownWindowsEventLogDataSourceStreams> streams;

    /*
     * A list of Windows Event Log queries in XPATH format.
     */
    private List<String> xPathQueries;

    /*
     * A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     */
    private String name;

    /**
     * Creates an instance of WindowsEventLogDataSource class.
     */
    public WindowsEventLogDataSource() {
    }

    /**
     * Get the streams property: List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will
     * be sent to.
     * 
     * @return the streams value.
     */
    public List<KnownWindowsEventLogDataSourceStreams> streams() {
        return this.streams;
    }

    /**
     * Set the streams property: List of streams that this data source will be sent to.
     * A stream indicates what schema will be used for this data and usually what table in Log Analytics the data will
     * be sent to.
     * 
     * @param streams the streams value to set.
     * @return the WindowsEventLogDataSource object itself.
     */
    public WindowsEventLogDataSource withStreams(List<KnownWindowsEventLogDataSourceStreams> streams) {
        this.streams = streams;
        return this;
    }

    /**
     * Get the xPathQueries property: A list of Windows Event Log queries in XPATH format.
     * 
     * @return the xPathQueries value.
     */
    public List<String> xPathQueries() {
        return this.xPathQueries;
    }

    /**
     * Set the xPathQueries property: A list of Windows Event Log queries in XPATH format.
     * 
     * @param xPathQueries the xPathQueries value to set.
     * @return the WindowsEventLogDataSource object itself.
     */
    public WindowsEventLogDataSource withXPathQueries(List<String> xPathQueries) {
        this.xPathQueries = xPathQueries;
        return this;
    }

    /**
     * Get the name property: A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: A friendly name for the data source.
     * This name should be unique across all data sources (regardless of type) within the data collection rule.
     * 
     * @param name the name value to set.
     * @return the WindowsEventLogDataSource object itself.
     */
    public WindowsEventLogDataSource withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("streams", this.streams,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("xPathQueries", this.xPathQueries, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WindowsEventLogDataSource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WindowsEventLogDataSource if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WindowsEventLogDataSource.
     */
    public static WindowsEventLogDataSource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WindowsEventLogDataSource deserializedWindowsEventLogDataSource = new WindowsEventLogDataSource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("streams".equals(fieldName)) {
                    List<KnownWindowsEventLogDataSourceStreams> streams = reader
                        .readArray(reader1 -> KnownWindowsEventLogDataSourceStreams.fromString(reader1.getString()));
                    deserializedWindowsEventLogDataSource.streams = streams;
                } else if ("xPathQueries".equals(fieldName)) {
                    List<String> xPathQueries = reader.readArray(reader1 -> reader1.getString());
                    deserializedWindowsEventLogDataSource.xPathQueries = xPathQueries;
                } else if ("name".equals(fieldName)) {
                    deserializedWindowsEventLogDataSource.name = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWindowsEventLogDataSource;
        });
    }
}
