// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Specifies a metric dimension.
 */
@Fluent
public final class MetricDimension implements JsonSerializable<MetricDimension> {
    /*
     * Name of the dimension.
     */
    private String name;

    /*
     * the dimension operator. Only 'Include' and 'Exclude' are supported
     */
    private String operator;

    /*
     * list of dimension values.
     */
    private List<String> values;

    /**
     * Creates an instance of MetricDimension class.
     */
    public MetricDimension() {
    }

    /**
     * Get the name property: Name of the dimension.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the dimension.
     * 
     * @param name the name value to set.
     * @return the MetricDimension object itself.
     */
    public MetricDimension withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the operator property: the dimension operator. Only 'Include' and 'Exclude' are supported.
     * 
     * @return the operator value.
     */
    public String operator() {
        return this.operator;
    }

    /**
     * Set the operator property: the dimension operator. Only 'Include' and 'Exclude' are supported.
     * 
     * @param operator the operator value to set.
     * @return the MetricDimension object itself.
     */
    public MetricDimension withOperator(String operator) {
        this.operator = operator;
        return this;
    }

    /**
     * Get the values property: list of dimension values.
     * 
     * @return the values value.
     */
    public List<String> values() {
        return this.values;
    }

    /**
     * Set the values property: list of dimension values.
     * 
     * @param values the values value to set.
     * @return the MetricDimension object itself.
     */
    public MetricDimension withValues(List<String> values) {
        this.values = values;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property name in model MetricDimension"));
        }
        if (operator() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property operator in model MetricDimension"));
        }
        if (values() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property values in model MetricDimension"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MetricDimension.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("operator", this.operator);
        jsonWriter.writeArrayField("values", this.values, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MetricDimension from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MetricDimension if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MetricDimension.
     */
    public static MetricDimension fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MetricDimension deserializedMetricDimension = new MetricDimension();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedMetricDimension.name = reader.getString();
                } else if ("operator".equals(fieldName)) {
                    deserializedMetricDimension.operator = reader.getString();
                } else if ("values".equals(fieldName)) {
                    List<String> values = reader.readArray(reader1 -> reader1.getString());
                    deserializedMetricDimension.values = values;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMetricDimension;
        });
    }
}
