/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.Actions;
import com.azure.resourcemanager.monitor.models.AlertSeverity;
import com.azure.resourcemanager.monitor.models.ScheduledQueryRuleCriteria;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class ScheduledQueryRuleProperties
implements JsonSerializable<ScheduledQueryRuleProperties> {
    private String createdWithApiVersion;
    private Boolean isLegacyLogAnalyticsRule;
    private String description;
    private String displayName;
    private AlertSeverity severity;
    private Boolean enabled;
    private List<String> scopes;
    private Duration evaluationFrequency;
    private Duration windowSize;
    private Duration overrideQueryTimeRange;
    private List<String> targetResourceTypes;
    private ScheduledQueryRuleCriteria criteria;
    private Duration muteActionsDuration;
    private Actions actions;
    private Boolean isWorkspaceAlertsStorageConfigured;
    private Boolean checkWorkspaceAlertsStorageConfigured;
    private Boolean skipQueryValidation;
    private Boolean autoMitigate;

    public String createdWithApiVersion() {
        return this.createdWithApiVersion;
    }

    public Boolean isLegacyLogAnalyticsRule() {
        return this.isLegacyLogAnalyticsRule;
    }

    public String description() {
        return this.description;
    }

    public ScheduledQueryRuleProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public ScheduledQueryRuleProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public AlertSeverity severity() {
        return this.severity;
    }

    public ScheduledQueryRuleProperties withSeverity(AlertSeverity severity) {
        this.severity = severity;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public ScheduledQueryRuleProperties withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<String> scopes() {
        return this.scopes;
    }

    public ScheduledQueryRuleProperties withScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public Duration evaluationFrequency() {
        return this.evaluationFrequency;
    }

    public ScheduledQueryRuleProperties withEvaluationFrequency(Duration evaluationFrequency) {
        this.evaluationFrequency = evaluationFrequency;
        return this;
    }

    public Duration windowSize() {
        return this.windowSize;
    }

    public ScheduledQueryRuleProperties withWindowSize(Duration windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    public Duration overrideQueryTimeRange() {
        return this.overrideQueryTimeRange;
    }

    public ScheduledQueryRuleProperties withOverrideQueryTimeRange(Duration overrideQueryTimeRange) {
        this.overrideQueryTimeRange = overrideQueryTimeRange;
        return this;
    }

    public List<String> targetResourceTypes() {
        return this.targetResourceTypes;
    }

    public ScheduledQueryRuleProperties withTargetResourceTypes(List<String> targetResourceTypes) {
        this.targetResourceTypes = targetResourceTypes;
        return this;
    }

    public ScheduledQueryRuleCriteria criteria() {
        return this.criteria;
    }

    public ScheduledQueryRuleProperties withCriteria(ScheduledQueryRuleCriteria criteria) {
        this.criteria = criteria;
        return this;
    }

    public Duration muteActionsDuration() {
        return this.muteActionsDuration;
    }

    public ScheduledQueryRuleProperties withMuteActionsDuration(Duration muteActionsDuration) {
        this.muteActionsDuration = muteActionsDuration;
        return this;
    }

    public Actions actions() {
        return this.actions;
    }

    public ScheduledQueryRuleProperties withActions(Actions actions) {
        this.actions = actions;
        return this;
    }

    public Boolean isWorkspaceAlertsStorageConfigured() {
        return this.isWorkspaceAlertsStorageConfigured;
    }

    public Boolean checkWorkspaceAlertsStorageConfigured() {
        return this.checkWorkspaceAlertsStorageConfigured;
    }

    public ScheduledQueryRuleProperties withCheckWorkspaceAlertsStorageConfigured(Boolean checkWorkspaceAlertsStorageConfigured) {
        this.checkWorkspaceAlertsStorageConfigured = checkWorkspaceAlertsStorageConfigured;
        return this;
    }

    public Boolean skipQueryValidation() {
        return this.skipQueryValidation;
    }

    public ScheduledQueryRuleProperties withSkipQueryValidation(Boolean skipQueryValidation) {
        this.skipQueryValidation = skipQueryValidation;
        return this;
    }

    public Boolean autoMitigate() {
        return this.autoMitigate;
    }

    public ScheduledQueryRuleProperties withAutoMitigate(Boolean autoMitigate) {
        this.autoMitigate = autoMitigate;
        return this;
    }

    public void validate() {
        if (this.criteria() != null) {
            this.criteria().validate();
        }
        if (this.actions() != null) {
            this.actions().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("severity", this.severity == null ? null : this.severity.toString());
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeArrayField("scopes", this.scopes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("evaluationFrequency", CoreUtils.durationToStringWithDays((Duration)this.evaluationFrequency));
        jsonWriter.writeStringField("windowSize", CoreUtils.durationToStringWithDays((Duration)this.windowSize));
        jsonWriter.writeStringField("overrideQueryTimeRange", CoreUtils.durationToStringWithDays((Duration)this.overrideQueryTimeRange));
        jsonWriter.writeArrayField("targetResourceTypes", this.targetResourceTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("criteria", (JsonSerializable)this.criteria);
        jsonWriter.writeStringField("muteActionsDuration", CoreUtils.durationToStringWithDays((Duration)this.muteActionsDuration));
        jsonWriter.writeJsonField("actions", (JsonSerializable)this.actions);
        jsonWriter.writeBooleanField("checkWorkspaceAlertsStorageConfigured", this.checkWorkspaceAlertsStorageConfigured);
        jsonWriter.writeBooleanField("skipQueryValidation", this.skipQueryValidation);
        jsonWriter.writeBooleanField("autoMitigate", this.autoMitigate);
        return jsonWriter.writeEndObject();
    }

    public static ScheduledQueryRuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ScheduledQueryRuleProperties)jsonReader.readObject(reader -> {
            ScheduledQueryRuleProperties deserializedScheduledQueryRuleProperties = new ScheduledQueryRuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createdWithApiVersion".equals(fieldName)) {
                    deserializedScheduledQueryRuleProperties.createdWithApiVersion = reader.getString();
                    continue;
                }
                if ("isLegacyLogAnalyticsRule".equals(fieldName)) {
                    deserializedScheduledQueryRuleProperties.isLegacyLogAnalyticsRule = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedScheduledQueryRuleProperties.description = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedScheduledQueryRuleProperties.displayName = reader.getString();
                    continue;
                }
                if ("severity".equals(fieldName)) {
                    deserializedScheduledQueryRuleProperties.severity = AlertSeverity.fromLong(reader.getLong());
                    continue;
                }
                if ("enabled".equals(fieldName)) {
                    deserializedScheduledQueryRuleProperties.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("scopes".equals(fieldName)) {
                    List scopes;
                    deserializedScheduledQueryRuleProperties.scopes = scopes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("evaluationFrequency".equals(fieldName)) {
                    deserializedScheduledQueryRuleProperties.evaluationFrequency = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("windowSize".equals(fieldName)) {
                    deserializedScheduledQueryRuleProperties.windowSize = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("overrideQueryTimeRange".equals(fieldName)) {
                    deserializedScheduledQueryRuleProperties.overrideQueryTimeRange = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("targetResourceTypes".equals(fieldName)) {
                    List targetResourceTypes;
                    deserializedScheduledQueryRuleProperties.targetResourceTypes = targetResourceTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("criteria".equals(fieldName)) {
                    deserializedScheduledQueryRuleProperties.criteria = ScheduledQueryRuleCriteria.fromJson(reader);
                    continue;
                }
                if ("muteActionsDuration".equals(fieldName)) {
                    deserializedScheduledQueryRuleProperties.muteActionsDuration = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    deserializedScheduledQueryRuleProperties.actions = Actions.fromJson(reader);
                    continue;
                }
                if ("isWorkspaceAlertsStorageConfigured".equals(fieldName)) {
                    deserializedScheduledQueryRuleProperties.isWorkspaceAlertsStorageConfigured = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("checkWorkspaceAlertsStorageConfigured".equals(fieldName)) {
                    deserializedScheduledQueryRuleProperties.checkWorkspaceAlertsStorageConfigured = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("skipQueryValidation".equals(fieldName)) {
                    deserializedScheduledQueryRuleProperties.skipQueryValidation = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("autoMitigate".equals(fieldName)) {
                    deserializedScheduledQueryRuleProperties.autoMitigate = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScheduledQueryRuleProperties;
        });
    }
}

