/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.MetricInner;
import java.io.IOException;
import java.time.Duration;
import java.util.List;

public final class ResponseInner
implements JsonSerializable<ResponseInner> {
    private Integer cost;
    private String timespan;
    private Duration interval;
    private String namespace;
    private String resourceRegion;
    private List<MetricInner> value;
    private static final ClientLogger LOGGER = new ClientLogger(ResponseInner.class);

    public Integer cost() {
        return this.cost;
    }

    public ResponseInner withCost(Integer cost) {
        this.cost = cost;
        return this;
    }

    public String timespan() {
        return this.timespan;
    }

    public ResponseInner withTimespan(String timespan) {
        this.timespan = timespan;
        return this;
    }

    public Duration interval() {
        return this.interval;
    }

    public ResponseInner withInterval(Duration interval) {
        this.interval = interval;
        return this;
    }

    public String namespace() {
        return this.namespace;
    }

    public ResponseInner withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public String resourceRegion() {
        return this.resourceRegion;
    }

    public ResponseInner withResourceRegion(String resourceRegion) {
        this.resourceRegion = resourceRegion;
        return this;
    }

    public List<MetricInner> value() {
        return this.value;
    }

    public ResponseInner withValue(List<MetricInner> value) {
        this.value = value;
        return this;
    }

    public void validate() {
        if (this.timespan() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property timespan in model ResponseInner"));
        }
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ResponseInner"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timespan", this.timespan);
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("cost", (Number)this.cost);
        jsonWriter.writeStringField("interval", CoreUtils.durationToStringWithDays((Duration)this.interval));
        jsonWriter.writeStringField("namespace", this.namespace);
        jsonWriter.writeStringField("resourceregion", this.resourceRegion);
        return jsonWriter.writeEndObject();
    }

    public static ResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return (ResponseInner)jsonReader.readObject(reader -> {
            ResponseInner deserializedResponseInner = new ResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timespan".equals(fieldName)) {
                    deserializedResponseInner.timespan = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedResponseInner.value = value = reader.readArray(reader1 -> MetricInner.fromJson(reader1));
                    continue;
                }
                if ("cost".equals(fieldName)) {
                    deserializedResponseInner.cost = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("interval".equals(fieldName)) {
                    deserializedResponseInner.interval = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("namespace".equals(fieldName)) {
                    deserializedResponseInner.namespace = reader.getString();
                    continue;
                }
                if ("resourceregion".equals(fieldName)) {
                    deserializedResponseInner.resourceRegion = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResponseInner;
        });
    }
}

