/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.ActionGroupPatch;
import java.io.IOException;
import java.util.Map;

public final class ActionGroupPatchBody
implements JsonSerializable<ActionGroupPatchBody> {
    private Map<String, String> tags;
    private ActionGroupPatch innerProperties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public ActionGroupPatchBody withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private ActionGroupPatch innerProperties() {
        return this.innerProperties;
    }

    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    public ActionGroupPatchBody withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ActionGroupPatch();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ActionGroupPatchBody fromJson(JsonReader jsonReader) throws IOException {
        return (ActionGroupPatchBody)jsonReader.readObject(reader -> {
            ActionGroupPatchBody deserializedActionGroupPatchBody = new ActionGroupPatchBody();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedActionGroupPatchBody.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedActionGroupPatchBody.innerProperties = ActionGroupPatch.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedActionGroupPatchBody;
        });
    }
}

