// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.DataContainer;
import com.azure.resourcemanager.monitor.models.DataStatus;
import com.azure.resourcemanager.monitor.models.OnboardingStatus;
import java.io.IOException;
import java.util.List;

/**
 * VM Insights onboarding status for a resource.
 */
@Fluent
public final class VMInsightsOnboardingStatusInner extends ProxyResource {
    /*
     * Resource properties.
     */
    private VMInsightsOnboardingStatusProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of VMInsightsOnboardingStatusInner class.
     */
    public VMInsightsOnboardingStatusInner() {
    }

    /**
     * Get the innerProperties property: Resource properties.
     * 
     * @return the innerProperties value.
     */
    private VMInsightsOnboardingStatusProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the resourceId property: Azure Resource Manager identifier of the resource whose onboarding status is being
     * represented.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceId();
    }

    /**
     * Set the resourceId property: Azure Resource Manager identifier of the resource whose onboarding status is being
     * represented.
     * 
     * @param resourceId the resourceId value to set.
     * @return the VMInsightsOnboardingStatusInner object itself.
     */
    public VMInsightsOnboardingStatusInner withResourceId(String resourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VMInsightsOnboardingStatusProperties();
        }
        this.innerProperties().withResourceId(resourceId);
        return this;
    }

    /**
     * Get the onboardingStatus property: The onboarding status for the resource. Note that, a higher level scope, e.g.,
     * resource group or subscription, is considered onboarded if at least one resource under it is onboarded.
     * 
     * @return the onboardingStatus value.
     */
    public OnboardingStatus onboardingStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().onboardingStatus();
    }

    /**
     * Set the onboardingStatus property: The onboarding status for the resource. Note that, a higher level scope, e.g.,
     * resource group or subscription, is considered onboarded if at least one resource under it is onboarded.
     * 
     * @param onboardingStatus the onboardingStatus value to set.
     * @return the VMInsightsOnboardingStatusInner object itself.
     */
    public VMInsightsOnboardingStatusInner withOnboardingStatus(OnboardingStatus onboardingStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VMInsightsOnboardingStatusProperties();
        }
        this.innerProperties().withOnboardingStatus(onboardingStatus);
        return this;
    }

    /**
     * Get the dataStatus property: The status of VM Insights data from the resource. When reported as `present` the
     * data array will contain information about the data containers to which data for the specified resource is being
     * routed.
     * 
     * @return the dataStatus value.
     */
    public DataStatus dataStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().dataStatus();
    }

    /**
     * Set the dataStatus property: The status of VM Insights data from the resource. When reported as `present` the
     * data array will contain information about the data containers to which data for the specified resource is being
     * routed.
     * 
     * @param dataStatus the dataStatus value to set.
     * @return the VMInsightsOnboardingStatusInner object itself.
     */
    public VMInsightsOnboardingStatusInner withDataStatus(DataStatus dataStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VMInsightsOnboardingStatusProperties();
        }
        this.innerProperties().withDataStatus(dataStatus);
        return this;
    }

    /**
     * Get the data property: Containers that currently store VM Insights data for the specified resource.
     * 
     * @return the data value.
     */
    public List<DataContainer> data() {
        return this.innerProperties() == null ? null : this.innerProperties().data();
    }

    /**
     * Set the data property: Containers that currently store VM Insights data for the specified resource.
     * 
     * @param data the data value to set.
     * @return the VMInsightsOnboardingStatusInner object itself.
     */
    public VMInsightsOnboardingStatusInner withData(List<DataContainer> data) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VMInsightsOnboardingStatusProperties();
        }
        this.innerProperties().withData(data);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VMInsightsOnboardingStatusInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VMInsightsOnboardingStatusInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the VMInsightsOnboardingStatusInner.
     */
    public static VMInsightsOnboardingStatusInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VMInsightsOnboardingStatusInner deserializedVMInsightsOnboardingStatusInner
                = new VMInsightsOnboardingStatusInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedVMInsightsOnboardingStatusInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedVMInsightsOnboardingStatusInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedVMInsightsOnboardingStatusInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedVMInsightsOnboardingStatusInner.innerProperties
                        = VMInsightsOnboardingStatusProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVMInsightsOnboardingStatusInner;
        });
    }
}
