// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Specifies an auto scale rule metric dimension.
 */
@Fluent
public final class ScaleRuleMetricDimension implements JsonSerializable<ScaleRuleMetricDimension> {
    /*
     * Name of the dimension.
     */
    private String dimensionName;

    /*
     * the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to any of the values.
     * 'NotEquals' being not equal to all of the values
     */
    private ScaleRuleMetricDimensionOperationType operator;

    /*
     * list of dimension values. For example: ["App1","App2"].
     */
    private List<String> values;

    /**
     * Creates an instance of ScaleRuleMetricDimension class.
     */
    public ScaleRuleMetricDimension() {
    }

    /**
     * Get the dimensionName property: Name of the dimension.
     * 
     * @return the dimensionName value.
     */
    public String dimensionName() {
        return this.dimensionName;
    }

    /**
     * Set the dimensionName property: Name of the dimension.
     * 
     * @param dimensionName the dimensionName value to set.
     * @return the ScaleRuleMetricDimension object itself.
     */
    public ScaleRuleMetricDimension withDimensionName(String dimensionName) {
        this.dimensionName = dimensionName;
        return this;
    }

    /**
     * Get the operator property: the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being
     * equal to any of the values. 'NotEquals' being not equal to all of the values.
     * 
     * @return the operator value.
     */
    public ScaleRuleMetricDimensionOperationType operator() {
        return this.operator;
    }

    /**
     * Set the operator property: the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being
     * equal to any of the values. 'NotEquals' being not equal to all of the values.
     * 
     * @param operator the operator value to set.
     * @return the ScaleRuleMetricDimension object itself.
     */
    public ScaleRuleMetricDimension withOperator(ScaleRuleMetricDimensionOperationType operator) {
        this.operator = operator;
        return this;
    }

    /**
     * Get the values property: list of dimension values. For example: ["App1","App2"].
     * 
     * @return the values value.
     */
    public List<String> values() {
        return this.values;
    }

    /**
     * Set the values property: list of dimension values. For example: ["App1","App2"].
     * 
     * @param values the values value to set.
     * @return the ScaleRuleMetricDimension object itself.
     */
    public ScaleRuleMetricDimension withValues(List<String> values) {
        this.values = values;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (dimensionName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property dimensionName in model ScaleRuleMetricDimension"));
        }
        if (operator() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property operator in model ScaleRuleMetricDimension"));
        }
        if (values() == null) {
            throw LOGGER.atError()
                .log(
                    new IllegalArgumentException("Missing required property values in model ScaleRuleMetricDimension"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ScaleRuleMetricDimension.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("DimensionName", this.dimensionName);
        jsonWriter.writeStringField("Operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeArrayField("Values", this.values, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScaleRuleMetricDimension from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScaleRuleMetricDimension if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ScaleRuleMetricDimension.
     */
    public static ScaleRuleMetricDimension fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScaleRuleMetricDimension deserializedScaleRuleMetricDimension = new ScaleRuleMetricDimension();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("DimensionName".equals(fieldName)) {
                    deserializedScaleRuleMetricDimension.dimensionName = reader.getString();
                } else if ("Operator".equals(fieldName)) {
                    deserializedScaleRuleMetricDimension.operator
                        = ScaleRuleMetricDimensionOperationType.fromString(reader.getString());
                } else if ("Values".equals(fieldName)) {
                    List<String> values = reader.readArray(reader1 -> reader1.getString());
                    deserializedScaleRuleMetricDimension.values = values;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedScaleRuleMetricDimension;
        });
    }
}
