// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Definition of custom data column.
 */
@Fluent
public final class ColumnDefinition implements JsonSerializable<ColumnDefinition> {
    /*
     * The name of the column.
     */
    private String name;

    /*
     * The type of the column data.
     */
    private KnownColumnDefinitionType type;

    /**
     * Creates an instance of ColumnDefinition class.
     */
    public ColumnDefinition() {
    }

    /**
     * Get the name property: The name of the column.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the column.
     * 
     * @param name the name value to set.
     * @return the ColumnDefinition object itself.
     */
    public ColumnDefinition withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: The type of the column data.
     * 
     * @return the type value.
     */
    public KnownColumnDefinitionType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of the column data.
     * 
     * @param type the type value to set.
     * @return the ColumnDefinition object itself.
     */
    public ColumnDefinition withType(KnownColumnDefinitionType type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ColumnDefinition from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ColumnDefinition if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ColumnDefinition.
     */
    public static ColumnDefinition fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ColumnDefinition deserializedColumnDefinition = new ColumnDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedColumnDefinition.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedColumnDefinition.type = KnownColumnDefinitionType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedColumnDefinition;
        });
    }
}
