/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.RuleCondition;
import com.azure.resourcemanager.monitor.models.RuleDataSource;
import java.io.IOException;
import java.time.Duration;

public final class LocationThresholdRuleCondition
extends RuleCondition {
    private String odataType = "Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition";
    private Duration windowSize;
    private int failedLocationCount;

    @Override
    public String odataType() {
        return this.odataType;
    }

    public Duration windowSize() {
        return this.windowSize;
    }

    public LocationThresholdRuleCondition withWindowSize(Duration windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    public int failedLocationCount() {
        return this.failedLocationCount;
    }

    public LocationThresholdRuleCondition withFailedLocationCount(int failedLocationCount) {
        this.failedLocationCount = failedLocationCount;
        return this;
    }

    @Override
    public LocationThresholdRuleCondition withDataSource(RuleDataSource dataSource) {
        super.withDataSource(dataSource);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("dataSource", (JsonSerializable)this.dataSource());
        jsonWriter.writeIntField("failedLocationCount", this.failedLocationCount);
        jsonWriter.writeStringField("odata.type", this.odataType);
        jsonWriter.writeStringField("windowSize", CoreUtils.durationToStringWithDays((Duration)this.windowSize));
        return jsonWriter.writeEndObject();
    }

    public static LocationThresholdRuleCondition fromJson(JsonReader jsonReader) throws IOException {
        return (LocationThresholdRuleCondition)jsonReader.readObject(reader -> {
            LocationThresholdRuleCondition deserializedLocationThresholdRuleCondition = new LocationThresholdRuleCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataSource".equals(fieldName)) {
                    deserializedLocationThresholdRuleCondition.withDataSource(RuleDataSource.fromJson(reader));
                    continue;
                }
                if ("failedLocationCount".equals(fieldName)) {
                    deserializedLocationThresholdRuleCondition.failedLocationCount = reader.getInt();
                    continue;
                }
                if ("odata.type".equals(fieldName)) {
                    deserializedLocationThresholdRuleCondition.odataType = reader.getString();
                    continue;
                }
                if ("windowSize".equals(fieldName)) {
                    deserializedLocationThresholdRuleCondition.windowSize = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLocationThresholdRuleCondition;
        });
    }
}

