// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Log Analytics destination.
 */
@Fluent
public final class LogAnalyticsDestination implements JsonSerializable<LogAnalyticsDestination> {
    /*
     * The resource ID of the Log Analytics workspace.
     */
    private String workspaceResourceId;

    /*
     * The Customer ID of the Log Analytics workspace.
     */
    private String workspaceId;

    /*
     * A friendly name for the destination.
     * This name should be unique across all destinations (regardless of type) within the data collection rule.
     */
    private String name;

    /**
     * Creates an instance of LogAnalyticsDestination class.
     */
    public LogAnalyticsDestination() {
    }

    /**
     * Get the workspaceResourceId property: The resource ID of the Log Analytics workspace.
     * 
     * @return the workspaceResourceId value.
     */
    public String workspaceResourceId() {
        return this.workspaceResourceId;
    }

    /**
     * Set the workspaceResourceId property: The resource ID of the Log Analytics workspace.
     * 
     * @param workspaceResourceId the workspaceResourceId value to set.
     * @return the LogAnalyticsDestination object itself.
     */
    public LogAnalyticsDestination withWorkspaceResourceId(String workspaceResourceId) {
        this.workspaceResourceId = workspaceResourceId;
        return this;
    }

    /**
     * Get the workspaceId property: The Customer ID of the Log Analytics workspace.
     * 
     * @return the workspaceId value.
     */
    public String workspaceId() {
        return this.workspaceId;
    }

    /**
     * Get the name property: A friendly name for the destination.
     * This name should be unique across all destinations (regardless of type) within the data collection rule.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: A friendly name for the destination.
     * This name should be unique across all destinations (regardless of type) within the data collection rule.
     * 
     * @param name the name value to set.
     * @return the LogAnalyticsDestination object itself.
     */
    public LogAnalyticsDestination withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("workspaceResourceId", this.workspaceResourceId);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LogAnalyticsDestination from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LogAnalyticsDestination if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the LogAnalyticsDestination.
     */
    public static LogAnalyticsDestination fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LogAnalyticsDestination deserializedLogAnalyticsDestination = new LogAnalyticsDestination();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("workspaceResourceId".equals(fieldName)) {
                    deserializedLogAnalyticsDestination.workspaceResourceId = reader.getString();
                } else if ("workspaceId".equals(fieldName)) {
                    deserializedLogAnalyticsDestination.workspaceId = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedLogAnalyticsDestination.name = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLogAnalyticsDestination;
        });
    }
}
