// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.monitor.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * A pointer to an Azure Action Group.
 */
@Fluent
public final class ActivityLogAlertActionGroup implements JsonSerializable<ActivityLogAlertActionGroup> {
    /*
     * The resource ID of the Action Group. This cannot be null or empty.
     */
    private String actionGroupId;

    /*
     * the dictionary of custom properties to include with the post operation. These data are appended to the webhook
     * payload.
     */
    private Map<String, String> webhookProperties;

    /**
     * Creates an instance of ActivityLogAlertActionGroup class.
     */
    public ActivityLogAlertActionGroup() {
    }

    /**
     * Get the actionGroupId property: The resource ID of the Action Group. This cannot be null or empty.
     * 
     * @return the actionGroupId value.
     */
    public String actionGroupId() {
        return this.actionGroupId;
    }

    /**
     * Set the actionGroupId property: The resource ID of the Action Group. This cannot be null or empty.
     * 
     * @param actionGroupId the actionGroupId value to set.
     * @return the ActivityLogAlertActionGroup object itself.
     */
    public ActivityLogAlertActionGroup withActionGroupId(String actionGroupId) {
        this.actionGroupId = actionGroupId;
        return this;
    }

    /**
     * Get the webhookProperties property: the dictionary of custom properties to include with the post operation. These
     * data are appended to the webhook payload.
     * 
     * @return the webhookProperties value.
     */
    public Map<String, String> webhookProperties() {
        return this.webhookProperties;
    }

    /**
     * Set the webhookProperties property: the dictionary of custom properties to include with the post operation. These
     * data are appended to the webhook payload.
     * 
     * @param webhookProperties the webhookProperties value to set.
     * @return the ActivityLogAlertActionGroup object itself.
     */
    public ActivityLogAlertActionGroup withWebhookProperties(Map<String, String> webhookProperties) {
        this.webhookProperties = webhookProperties;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (actionGroupId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property actionGroupId in model ActivityLogAlertActionGroup"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ActivityLogAlertActionGroup.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("actionGroupId", this.actionGroupId);
        jsonWriter.writeMapField("webhookProperties", this.webhookProperties,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ActivityLogAlertActionGroup from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ActivityLogAlertActionGroup if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ActivityLogAlertActionGroup.
     */
    public static ActivityLogAlertActionGroup fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ActivityLogAlertActionGroup deserializedActivityLogAlertActionGroup = new ActivityLogAlertActionGroup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("actionGroupId".equals(fieldName)) {
                    deserializedActivityLogAlertActionGroup.actionGroupId = reader.getString();
                } else if ("webhookProperties".equals(fieldName)) {
                    Map<String, String> webhookProperties = reader.readMap(reader1 -> reader1.getString());
                    deserializedActivityLogAlertActionGroup.webhookProperties = webhookProperties;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedActivityLogAlertActionGroup;
        });
    }
}
