/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.monitor.models.AccessModeSettings;
import java.io.IOException;
import java.util.List;

public final class AzureMonitorPrivateLinkScopeProperties
implements JsonSerializable<AzureMonitorPrivateLinkScopeProperties> {
    private String provisioningState;
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    private AccessModeSettings accessModeSettings;
    private static final ClientLogger LOGGER = new ClientLogger(AzureMonitorPrivateLinkScopeProperties.class);

    public String provisioningState() {
        return this.provisioningState;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public AccessModeSettings accessModeSettings() {
        return this.accessModeSettings;
    }

    public AzureMonitorPrivateLinkScopeProperties withAccessModeSettings(AccessModeSettings accessModeSettings) {
        this.accessModeSettings = accessModeSettings;
        return this;
    }

    public void validate() {
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.accessModeSettings() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property accessModeSettings in model AzureMonitorPrivateLinkScopeProperties"));
        }
        this.accessModeSettings().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("accessModeSettings", (JsonSerializable)this.accessModeSettings);
        return jsonWriter.writeEndObject();
    }

    public static AzureMonitorPrivateLinkScopeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureMonitorPrivateLinkScopeProperties)jsonReader.readObject(reader -> {
            AzureMonitorPrivateLinkScopeProperties deserializedAzureMonitorPrivateLinkScopeProperties = new AzureMonitorPrivateLinkScopeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accessModeSettings".equals(fieldName)) {
                    deserializedAzureMonitorPrivateLinkScopeProperties.accessModeSettings = AccessModeSettings.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedAzureMonitorPrivateLinkScopeProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("privateEndpointConnections".equals(fieldName)) {
                    List privateEndpointConnections;
                    deserializedAzureMonitorPrivateLinkScopeProperties.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnectionInner.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureMonitorPrivateLinkScopeProperties;
        });
    }
}

